/*
 * Decompiled with CFR 0.152.
 */
package weblogic.invocation;

import java.security.Principal;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import weblogic.diagnostics.debug.DebugLogger;
import weblogic.invocation.ComponentInvocationContext;
import weblogic.invocation.ComponentInvocationContextChangeListener;
import weblogic.invocation.ManagedInvocationContext;
import weblogic.invocation.ReadOnlyComponentInvocationContextManager;

public abstract class ComponentInvocationContextManager {
    private static final boolean IS_WARN_ENABLED = Boolean.getBoolean("weblogic.debug.WarnUnsecureCICAccess");
    private static final boolean IS_CONDENSE_DISABLED = Boolean.getBoolean("weblogic.debug.EnableFullCICAccessStacks");
    private static Set<List<StackTraceElement>> alreadyWarnedSet = new HashSet<List<StackTraceElement>>();

    public static ComponentInvocationContextManager getInstance() {
        if (IS_WARN_ENABLED) {
            return new ReadOnlyComponentInvocationContextManager(SingletonHolder.INSTANCE);
        }
        return SingletonHolder.INSTANCE;
    }

    public static ComponentInvocationContextManager getInstance(Principal subject) {
        try {
            SingletonHolder.INSTANCE.checkIfKernel(subject);
            return SingletonHolder.INSTANCE;
        }
        catch (SecurityException se) {
            se.printStackTrace();
            throw se;
        }
    }

    public abstract ComponentInvocationContext createComponentInvocationContext(String var1, String var2, String var3);

    public abstract ComponentInvocationContext createComponentInvocationContext(String var1, String var2, String var3, String var4, String var5);

    public ComponentInvocationContext createComponentInvocationContext(String partitionName) {
        return this.createComponentInvocationContext(partitionName, null, null, null, null);
    }

    public abstract ComponentInvocationContext getCurrentComponentInvocationContext();

    @Deprecated
    public abstract void pushComponentInvocationContext(ComponentInvocationContext var1);

    @Deprecated
    public abstract void popComponentInvocationContext();

    public abstract ManagedInvocationContext setCurrentComponentInvocationContext(ComponentInvocationContext var1);

    @Deprecated
    public static <T> T runAs(ComponentInvocationContext ci, Callable<T> action) throws ExecutionException {
        ComponentInvocationContextManager.warnUnsecureCallers();
        return ComponentInvocationContextManager._runAs(ci, action);
    }

    public static <T> T runAs(Principal subject, ComponentInvocationContext ci, Callable<T> action) throws ExecutionException {
        SingletonHolder.INSTANCE.checkIfKernel(subject);
        return ComponentInvocationContextManager._runAs(ci, action);
    }

    private static <T> T _runAs(ComponentInvocationContext ci, Callable<T> action) throws ExecutionException {
        Throwable throwable = null;
        try (ManagedInvocationContext ignored = SingletonHolder.INSTANCE.setCurrentComponentInvocationContext(ci);){
            T t = action.call();
            return t;
        }
        catch (Exception e) {
            try {
                throw new ExecutionException(e);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    @Deprecated
    public static void runAs(ComponentInvocationContext ci, Runnable action) throws ExecutionException {
        ComponentInvocationContextManager.warnUnsecureCallers();
        ComponentInvocationContextManager._runAs(ci, action);
    }

    public static void runAs(Principal subject, ComponentInvocationContext ci, Runnable action) throws ExecutionException {
        SingletonHolder.INSTANCE.checkIfKernel(subject);
        ComponentInvocationContextManager._runAs(ci, action);
    }

    private static void _runAs(ComponentInvocationContext ci, Runnable action) throws ExecutionException {
        try (ManagedInvocationContext ignored = SingletonHolder.INSTANCE.setCurrentComponentInvocationContext(ci);){
            try {
                action.run();
            }
            catch (RuntimeException e) {
                throw new ExecutionException(e);
            }
        }
    }

    public abstract void addInvocationContextChangeListener(ComponentInvocationContextChangeListener var1);

    public abstract void removeInvocationContextChangeListener(ComponentInvocationContextChangeListener var1);

    protected abstract void checkIfKernel(Principal var1);

    protected static void warnUnsecureCallers() {
        StackTraceElement[] sEltsArr;
        List<StackTraceElement> stackElts;
        if (IS_WARN_ENABLED && !alreadyWarnedSet.contains(stackElts = Arrays.asList(sEltsArr = Thread.currentThread().getStackTrace()))) {
            alreadyWarnedSet.add(stackElts);
            DebugLogger.println("Unsecure CIC caller: " + ComponentInvocationContextManager.formatTrace(sEltsArr));
        }
    }

    protected static String formatTrace(StackTraceElement[] stackTraceElements) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i <= stackTraceElements.length - 1; ++i) {
            StackTraceElement elt = stackTraceElements[i];
            if (i == 0) continue;
            if (!IS_CONDENSE_DISABLED && i > 10) break;
            sb.append(elt).append(System.lineSeparator());
        }
        return sb.toString();
    }

    private static final class SingletonHolder {
        private static final ComponentInvocationContextManager INSTANCE = SingletonHolder.init();

        private SingletonHolder() {
        }

        private static ComponentInvocationContextManager init() {
            Iterator<ComponentInvocationContextManager> iterator = ServiceLoader.load(ComponentInvocationContextManager.class).iterator();
            if (iterator.hasNext()) {
                ComponentInvocationContextManager cim = iterator.next();
                return cim;
            }
            throw new RuntimeException("META-INF/services/" + ComponentInvocationContextManager.class.getName() + " is not found in the search path of Thread Context ClassLoader");
        }
    }
}

