/*
 * Decompiled with CFR 0.152.
 */
package weblogic.i18n.logging;

import java.util.logging.Level;

public class Severities {
    public static final int OFF = 0;
    public static final String OFF_TEXT = "Off";
    public static final int EMERGENCY = 1;
    public static final String EMERGENCY_TEXT = "Emergency";
    public static final int ALERT = 2;
    public static final String ALERT_TEXT = "Alert";
    public static final int CRITICAL = 4;
    public static final String CRITICAL_TEXT = "Critical";
    public static final int ERROR = 8;
    public static final String ERROR_TEXT = "Error";
    public static final int WARNING = 16;
    public static final String WARNING_TEXT = "Warning";
    public static final int NOTICE = 32;
    public static final String NOTICE_TEXT = "Notice";
    public static final int INFO = 64;
    public static final String INFO_TEXT = "Info";
    public static final int DEBUG = 128;
    public static final String DEBUG_TEXT = "Debug";
    public static final int TRACE = 256;
    public static final String TRACE_TEXT = "Trace";
    public static final int DYNAMIC = 512;
    public static final String DYNAMIC_TEXT = "Dynamic";

    public static String severityNumToString(int num) {
        switch (num) {
            case 0: {
                return OFF_TEXT;
            }
            case 1: {
                return EMERGENCY_TEXT;
            }
            case 2: {
                return ALERT_TEXT;
            }
            case 4: {
                return CRITICAL_TEXT;
            }
            case 32: {
                return NOTICE_TEXT;
            }
            case 8: {
                return ERROR_TEXT;
            }
            case 16: {
                return WARNING_TEXT;
            }
            case 64: {
                return INFO_TEXT;
            }
            case 128: {
                return DEBUG_TEXT;
            }
            case 256: {
                return TRACE_TEXT;
            }
            case 512: {
                return DYNAMIC_TEXT;
            }
        }
        return "Unknown";
    }

    public static int severityStringToNum(String sevstr) {
        if (sevstr.equalsIgnoreCase(OFF_TEXT)) {
            return 0;
        }
        if (sevstr.equalsIgnoreCase(EMERGENCY_TEXT)) {
            return 1;
        }
        if (sevstr.equalsIgnoreCase(ALERT_TEXT)) {
            return 2;
        }
        if (sevstr.equalsIgnoreCase(CRITICAL_TEXT)) {
            return 4;
        }
        if (sevstr.equalsIgnoreCase(NOTICE_TEXT)) {
            return 32;
        }
        if (sevstr.equalsIgnoreCase(ERROR_TEXT)) {
            return 8;
        }
        if (sevstr.equalsIgnoreCase(WARNING_TEXT)) {
            return 16;
        }
        if (sevstr.equalsIgnoreCase(INFO_TEXT)) {
            return 64;
        }
        if (sevstr.equalsIgnoreCase(DEBUG_TEXT)) {
            return 128;
        }
        if (sevstr.equalsIgnoreCase(TRACE_TEXT)) {
            return 256;
        }
        if (sevstr.equalsIgnoreCase(DYNAMIC_TEXT)) {
            return 512;
        }
        return 0;
    }

    public static String severityStringToSymbol(String sevstr) {
        if (sevstr.equalsIgnoreCase(OFF_TEXT)) {
            return "Severities.OFF";
        }
        if (sevstr.equalsIgnoreCase(EMERGENCY_TEXT)) {
            return "Severities.EMERGENCY";
        }
        if (sevstr.equalsIgnoreCase(ALERT_TEXT)) {
            return "Severities.ALERT";
        }
        if (sevstr.equalsIgnoreCase(CRITICAL_TEXT)) {
            return "Severities.CRITICAL";
        }
        if (sevstr.equalsIgnoreCase(NOTICE_TEXT)) {
            return "Severities.NOTICE";
        }
        if (sevstr.equalsIgnoreCase(ERROR_TEXT)) {
            return "Severities.ERROR";
        }
        if (sevstr.equalsIgnoreCase(WARNING_TEXT)) {
            return "Severities.WARNING";
        }
        if (sevstr.equalsIgnoreCase(INFO_TEXT)) {
            return "Severities.INFO";
        }
        if (sevstr.equalsIgnoreCase(DEBUG_TEXT)) {
            return "Severities.DEBUG";
        }
        if (sevstr.equalsIgnoreCase(TRACE_TEXT)) {
            return "Severities.TRACE";
        }
        if (sevstr.equalsIgnoreCase(DYNAMIC_TEXT)) {
            return "Severities.DYNAMIC";
        }
        return "0";
    }

    public static Level severityToJDKLoggerLevel(int severity) {
        switch (severity) {
            case 0: {
                return Level.OFF;
            }
            case 1: {
                return Level.SEVERE;
            }
            case 4: {
                return Level.SEVERE;
            }
            case 2: {
                return Level.WARNING;
            }
            case 8: {
                return Level.WARNING;
            }
            case 16: {
                return Level.WARNING;
            }
            case 32: {
                return Level.INFO;
            }
            case 64: {
                return Level.INFO;
            }
            case 128: {
                return Level.FINEST;
            }
            case 256: {
                return Level.FINER;
            }
        }
        return Level.FINE;
    }

    public static int getSeverity(Level level) {
        int levelValue = level.intValue();
        if (levelValue == Integer.MAX_VALUE) {
            return 0;
        }
        if (levelValue >= Level.SEVERE.intValue()) {
            return 1;
        }
        if (levelValue >= Level.WARNING.intValue()) {
            return 16;
        }
        if (levelValue >= Level.INFO.intValue()) {
            return 64;
        }
        if (levelValue >= Level.FINE.intValue()) {
            return 128;
        }
        return 256;
    }
}

