/*
 * Decompiled with CFR 0.152.
 */
package weblogic.i18n.logging;

import weblogic.i18n.logging.BasicLogMessageFormatter;
import weblogic.i18n.logging.LogMessage;
import weblogic.i18n.logging.MessageDispatcher;
import weblogic.i18n.logging.MessageLogger;

public class BasicMessageLogger
implements MessageLogger,
MessageDispatcher {
    private static final String FIELD_PREFIX = "<";
    private static final String FIELD_SUFFIX = "> ";
    private BasicLogMessageFormatter formatter = new BasicLogMessageFormatter("<", "> ");

    @Override
    public boolean isSeverityEnabled(String subSystem, int messageSeverity) {
        return true;
    }

    @Override
    public void log(String subsystem, int severityLevel, String message) {
        this.log(subsystem, severityLevel, message, null);
    }

    @Override
    public void log(String subsystem, int severityLevel, String message, Throwable throwable) {
        this.log(new LogMessage("", "", subsystem, severityLevel, message, throwable));
    }

    @Override
    public void log(LogMessage logMessage) {
        String msg = this.formatter.formatLogMessage(logMessage);
        System.out.println(msg);
    }

    @Override
    public MessageDispatcher getMessageDispatcher(String name) {
        return this;
    }

    @Override
    public String getName() {
        return "";
    }

    @Override
    public boolean isSeverityEnabled(int severity) {
        return true;
    }

    @Override
    public int getSeverity() {
        return 64;
    }

    @Override
    public void setSeverity(int severity) {
    }
}

