/*
 * Decompiled with CFR 0.152.
 */
package weblogic.i18n;

import java.text.DecimalFormat;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public final class Localizer {
    private static final String EMPTY_STRING = "";
    public static final String VERSION = "version";
    public static final String L10N_PACKAGE = "L10nPackage";
    public static final String I18N_PACKAGE = "I18nPackage";
    public static final String SUBSYSTEM = "subsystem";
    public static final String PREFIX = "prefix";
    public static final String SEVERITY = "severity";
    public static final String MESSAGE_BODY = "messagebody";
    public static final String MESSAGE_DETAIL = "messagedetail";
    public static final String CAUSE = "cause";
    public static final String ACTION = "action";
    public static final String STACKTRACE = "stack";
    public static final String DIAGNOSTIC_VOLUME = "diagnosticvolume";
    public static final String EXCLUDE_PARTITIONED = "exclude_partition";
    public static final String[] SERVER_SEVERITIES = new String[]{"Emergency".toLowerCase(), "Alert".toLowerCase(), "Critical".toLowerCase(), "Notice".toLowerCase(), "Error".toLowerCase(), "Warning".toLowerCase(), "Info".toLowerCase(), "Debug".toLowerCase(), "Dynamic".toLowerCase()};
    public static final String[] NON_SERVER_SEVERITIES = new String[]{"Error".toLowerCase(), "Warning".toLowerCase(), "Info".toLowerCase(), "Debug".toLowerCase(), "Dynamic".toLowerCase()};
    public static final String PREFIX_DELIM = "-";
    private ResourceBundle bundle;

    public Localizer(ResourceBundle rb) {
        this.bundle = rb;
    }

    public ResourceBundle getBundle() {
        return this.bundle;
    }

    public String getVersion() throws MissingResourceException {
        return (String)this.bundle.getObject(VERSION);
    }

    public String getL10nPackage() throws MissingResourceException {
        return (String)this.bundle.getObject(L10N_PACKAGE);
    }

    public String getI18nPackage() throws MissingResourceException {
        return (String)this.bundle.getObject(I18N_PACKAGE);
    }

    public String getSubSystem() throws MissingResourceException {
        return (String)this.bundle.getObject(SUBSYSTEM);
    }

    public String getPrefix() {
        String prefix = null;
        try {
            prefix = (String)this.bundle.getObject(PREFIX);
            if (prefix != null && prefix.length() == 0) {
                prefix = null;
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return prefix;
    }

    public Object getObject(String key, String id) throws MissingResourceException {
        return this.bundle.getObject(key + this.prune(id));
    }

    public Object getObject(String id) throws MissingResourceException {
        return this.bundle.getObject(id);
    }

    public Object getObject(String key, int id) throws MissingResourceException {
        DecimalFormat df = new DecimalFormat("000000");
        return this.getObject(key, df.format(id));
    }

    public String getString(String key, String id) throws MissingResourceException {
        return this.getObject(key, id).toString();
    }

    public String getString(String key, int id) throws MissingResourceException {
        DecimalFormat df = new DecimalFormat("000000");
        return this.getString(key, df.format(id));
    }

    public String get(String id) {
        return this.getString(EMPTY_STRING, id);
    }

    public String getBody(String id) {
        try {
            return (String)this.getObject(MESSAGE_BODY, id);
        }
        catch (MissingResourceException mre) {
            return EMPTY_STRING;
        }
    }

    public String getBody2(String id) {
        try {
            return (String)this.getObject(id);
        }
        catch (MissingResourceException mre) {
            try {
                return (String)this.getObject(MESSAGE_BODY, id);
            }
            catch (MissingResourceException mre2) {
                return EMPTY_STRING;
            }
        }
    }

    public String getDetail(String id) {
        try {
            return (String)this.getObject(MESSAGE_DETAIL, id);
        }
        catch (MissingResourceException mre) {
            return EMPTY_STRING;
        }
    }

    public String getCause(String id) {
        try {
            return (String)this.getObject(CAUSE, id);
        }
        catch (MissingResourceException mre) {
            return EMPTY_STRING;
        }
    }

    public String getAction(String id) {
        try {
            return (String)this.getObject(ACTION, id);
        }
        catch (MissingResourceException mre) {
            return EMPTY_STRING;
        }
    }

    public int getSeverity(String id) {
        try {
            PropertyResourceBundle propRes;
            Object val;
            String key = SEVERITY + this.prune(id);
            if (this.bundle instanceof PropertyResourceBundle && (val = (propRes = (PropertyResourceBundle)this.bundle).handleGetObject(key)) != null) {
                return Integer.parseInt((String)val);
            }
            return Integer.parseInt((String)this.getObject(SEVERITY, id));
        }
        catch (MissingResourceException mre) {
            return 8;
        }
        catch (NumberFormatException nfe) {
            return 8;
        }
    }

    public boolean getStackTrace(String id) {
        String key = STACKTRACE + this.prune(id);
        try {
            PropertyResourceBundle propRes;
            Object val;
            if (this.bundle instanceof PropertyResourceBundle && (val = (propRes = (PropertyResourceBundle)this.bundle).handleGetObject(key)) != null) {
                return val.equals("true");
            }
            return ((String)this.getObject(STACKTRACE, id)).equals("true");
        }
        catch (MissingResourceException mre) {
            return true;
        }
    }

    public String getDiagnosticVolume(String id) {
        String key = DIAGNOSTIC_VOLUME + this.prune(id);
        try {
            PropertyResourceBundle propRes;
            Object val;
            if (this.bundle instanceof PropertyResourceBundle && (val = (propRes = (PropertyResourceBundle)this.bundle).handleGetObject(key)) != null) {
                return (String)val;
            }
            return (String)this.getObject(DIAGNOSTIC_VOLUME, id);
        }
        catch (MissingResourceException mre) {
            return "Off";
        }
    }

    private String prune(String id) {
        String prefix = this.getPrefix();
        String retval = id;
        if (prefix != null && id.indexOf(prefix + PREFIX_DELIM) != -1) {
            retval = id.substring(prefix.length() + 1);
        }
        return retval;
    }
}

