/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb20.internal;

import jakarta.ejb.FinderException;
import java.io.Serializable;
import java.sql.ResultSet;
import java.util.Collection;
import java.util.Properties;
import weblogic.ejb.Query;
import weblogic.ejb20.interfaces.QueryHandler;
import weblogic.ejb20.internal.WLQueryPropertiesImpl;
import weblogic.utils.StackTraceUtils;

public class QueryImpl
extends WLQueryPropertiesImpl
implements Query,
Serializable {
    private static final long serialVersionUID = -6324059333171473291L;
    private QueryHandler handler;
    private boolean isSql = false;

    public QueryImpl(QueryHandler handler) {
        this.handler = handler;
    }

    public QueryImpl(QueryHandler handler, boolean isSql) {
        this.handler = handler;
        this.isSql = isSql;
    }

    @Override
    public String getLanguage() {
        if (this.isSql) {
            return "SQL";
        }
        return "EJB QL";
    }

    @Override
    public Collection find(String query) throws FinderException {
        try {
            return (Collection)this.handler.executeQuery(query, this, false, this.isSql);
        }
        catch (FinderException fe) {
            throw fe;
        }
        catch (Throwable th) {
            throw new FinderException(StackTraceUtils.throwable2StackTrace(th));
        }
    }

    @Override
    public Collection find(String query, Properties props) throws FinderException {
        this.setProperties(props);
        try {
            return (Collection)this.handler.executeQuery(query, this, false, this.isSql);
        }
        catch (FinderException fe) {
            throw fe;
        }
        catch (Throwable th) {
            throw new FinderException(StackTraceUtils.throwable2StackTrace(th));
        }
    }

    @Override
    public ResultSet execute(String query) throws FinderException {
        try {
            return (ResultSet)this.handler.executeQuery(query, this, true, this.isSql);
        }
        catch (FinderException fe) {
            throw fe;
        }
        catch (Throwable th) {
            throw new FinderException(StackTraceUtils.throwable2StackTrace(th));
        }
    }

    @Override
    public ResultSet execute(String query, Properties props) throws FinderException {
        this.setProperties(props);
        try {
            return (ResultSet)this.handler.executeQuery(query, this, true, this.isSql);
        }
        catch (FinderException fe) {
            throw fe;
        }
        catch (Throwable th) {
            throw new FinderException(StackTraceUtils.throwable2StackTrace(th));
        }
    }
}

