/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.internal;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import weblogic.ejb.container.deployer.DownloadRemoteBizIntfClassLoader;
import weblogic.ejb.container.deployer.RemoteBizIntfClassLoader;
import weblogic.utils.classloaders.AugmentableClassLoaderManager;
import weblogic.utils.classloaders.GenericClassLoader;

@Deprecated
public final class RemoteBusinessIntfGenerator {
    private String remoteInterfaceName;
    private Class businessInterface;
    private Class generatedRemoteInterface;
    private GenericClassLoader cl;
    private static final ReferenceQueue referenceQueue = new ReferenceQueue();
    private static final Map<LoaderCacheKey, WeakReference> classLoaderCache = new HashMap<LoaderCacheKey, WeakReference>();
    private static boolean debug = Boolean.getBoolean("weblogic.ejb.enhancement.debug");

    public RemoteBusinessIntfGenerator(String remoteInterfaceName, Class businessInterface, GenericClassLoader cl) {
        this.remoteInterfaceName = remoteInterfaceName;
        this.businessInterface = businessInterface;
        this.cl = cl;
    }

    public Class getGeneratedRemoteInterface() {
        return this.generatedRemoteInterface;
    }

    public Class generateRemoteInterface() {
        Method[] ms;
        boolean createDownloadLoader = false;
        for (Method m : ms = this.businessInterface.getMethods()) {
            if (m.toGenericString().equals(m.toString()) || !this.isGenericInterfaceDeclared(this.businessInterface)) continue;
            createDownloadLoader = true;
            break;
        }
        String biName = this.businessInterface.getName();
        if (!createDownloadLoader) {
            try {
                RemoteBizIntfClassLoader enhanceCL = this.getEnhanceLoader();
                Class<?> enhancedClass = enhanceCL.loadClass(biName);
                this.debug("loaded by enhanceCL:" + enhancedClass.getName());
                if (enhancedClass.getName().equals(this.remoteInterfaceName)) {
                    this.generatedRemoteInterface = enhancedClass;
                    this.debug("get generatedRemoteInterface:" + this.generatedRemoteInterface + " by enhancing business interface on RemoteBizIntfClassLoader: \n" + enhanceCL);
                } else {
                    this.generatedRemoteInterface = enhanceCL.loadClass(this.remoteInterfaceName);
                    this.debug("get generatedRemoteInterface:" + this.generatedRemoteInterface + " by loading it directly on RemoteBizIntfClassLoader: \n" + enhanceCL);
                }
                return this.generatedRemoteInterface;
            }
            catch (ClassNotFoundException e) {
                throw new AssertionError((Object)e);
            }
        }
        DownloadRemoteBizIntfClassLoader cpp = null;
        try {
            cpp = new DownloadRemoteBizIntfClassLoader(this.remoteInterfaceName, this.cl);
            Class<?> enhancedClass = cpp.loadClass(biName);
            if (enhancedClass.getName().equals(this.remoteInterfaceName)) {
                this.generatedRemoteInterface = enhancedClass;
                this.debug("get generatedRemoteInterface:" + this.generatedRemoteInterface + " by enhancing business interface on RemoteBizIntfClassLoader: \n" + cpp);
            } else {
                this.generatedRemoteInterface = cpp.loadClass(this.remoteInterfaceName);
                this.debug("get generatedRemoteInterface:" + this.generatedRemoteInterface + " by loading it directly on RemoteBizIntfClassLoader: \n" + cpp);
            }
            return this.generatedRemoteInterface;
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
    }

    private void processQueue() {
        CacheKeyReference ref;
        while ((ref = (CacheKeyReference)((Object)referenceQueue.poll())) != null) {
            classLoaderCache.remove(ref.getCacheKey());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RemoteBizIntfClassLoader getEnhanceLoader() {
        if (debug) {
            this.debug("enhance loader cache: " + classLoaderCache);
        }
        this.debug("businessInterface: " + this.businessInterface.getName() + " and generated interface: " + this.remoteInterfaceName);
        LoaderCacheKey key = new LoaderCacheKey(this.businessInterface.getName(), this.remoteInterfaceName, this.cl);
        RemoteBizIntfClassLoader gcl = null;
        Map<LoaderCacheKey, WeakReference> map = classLoaderCache;
        synchronized (map) {
            this.processQueue();
            WeakReference<RemoteBizIntfClassLoader> ref = classLoaderCache.get(key);
            if (ref == null || ref.get() == null) {
                gcl = new RemoteBizIntfClassLoader(this.businessInterface.getName(), this.remoteInterfaceName, this.cl);
                ref = new WeakReference<RemoteBizIntfClassLoader>(gcl);
                classLoaderCache.put(key, ref);
                if (debug) {
                    this.debug("newly created RemoteBizIntfClassLoader: " + gcl + " enhanceLoaderCache: " + classLoaderCache);
                }
            } else {
                gcl = (RemoteBizIntfClassLoader)ref.get();
                this.debug("got RemoteBizIntfClassLoader from cache: " + gcl);
            }
        }
        return gcl;
    }

    private boolean isGenericInterfaceDeclared(Type c) {
        if (c == null) {
            return false;
        }
        if (!(c instanceof Class)) {
            return true;
        }
        Class cls = (Class)c;
        if (!cls.isInterface()) {
            return false;
        }
        Type[] superIntfs = cls.getGenericInterfaces();
        if (superIntfs.length == 0) {
            return cls.getTypeParameters().length != 0;
        }
        int n = 0;
        Type[] typeArray = superIntfs;
        int n2 = typeArray.length;
        if (n < n2) {
            Type t = typeArray[n];
            return this.isGenericInterfaceDeclared(t);
        }
        return false;
    }

    private static void dumpIfaceInfo(Class iface) {
        System.out.println("iface name: " + iface.getName());
        System.out.println("isInterface: " + iface.isInterface());
        System.out.println("super: " + iface.getSuperclass());
        for (Class<?> clazz : iface.getInterfaces()) {
            System.out.println("implemented interface: " + clazz);
        }
        for (GenericDeclaration genericDeclaration : iface.getMethods()) {
            System.out.println("Method: " + genericDeclaration);
        }
        System.out.println("\n");
    }

    public static void main(String[] argv) {
        if (argv.length != 1) {
            System.out.println("Usage: java RemoteBusinessIntfGenerator <remote-business-interface-name>");
            return;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            String businessInterfaceName = argv[0];
            Class<?> businessInterface = cl.loadClass(businessInterfaceName);
            GenericClassLoader gcl = AugmentableClassLoaderManager.getAugmentableClassLoader(cl);
            RemoteBusinessIntfGenerator generator = new RemoteBusinessIntfGenerator(businessInterfaceName + "Remote", businessInterface, gcl);
            Class ri = generator.generateRemoteInterface();
            RemoteBusinessIntfGenerator.dumpIfaceInfo(ri);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void debug(String log) {
        if (debug) {
            System.out.println("[" + this.getClass().getSimpleName() + "]---" + Thread.currentThread() + "---\n\t" + log);
        }
    }

    private static class LoaderReference
    extends WeakReference<ClassLoader>
    implements CacheKeyReference {
        private LoaderCacheKey loaderCacheKey;

        LoaderReference(ClassLoader referent, ReferenceQueue q, LoaderCacheKey loaderCacheKey) {
            super(referent, q);
            this.loaderCacheKey = loaderCacheKey;
        }

        @Override
        public LoaderCacheKey getCacheKey() {
            return this.loaderCacheKey;
        }
    }

    private static class LoaderCacheKey {
        private String biName;
        private String remoteBIName;
        private LoaderReference appLoader;
        private final int hashCode;

        public LoaderCacheKey(String biName, String remoteBIName, GenericClassLoader appLoader) {
            if (biName == null || remoteBIName == null || appLoader == null) {
                throw new AssertionError((Object)("Invalid loader cache key. business interface name: " + biName + ", remote business interface name: " + remoteBIName + ",\nGenericClassLoader: " + appLoader));
            }
            this.biName = biName;
            this.remoteBIName = remoteBIName;
            this.appLoader = new LoaderReference(appLoader, referenceQueue, this);
            this.hashCode = biName.hashCode() ^ remoteBIName.hashCode() ^ appLoader.hashCode();
        }

        public boolean equals(Object obj) {
            ClassLoader refLoader;
            if (!(obj instanceof LoaderCacheKey)) {
                return false;
            }
            LoaderCacheKey key = (LoaderCacheKey)obj;
            return this.biName.equals(key.biName) && this.remoteBIName.equals(key.remoteBIName) && (refLoader = (ClassLoader)this.appLoader.get()) != null && refLoader == key.appLoader.get();
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    private static interface CacheKeyReference {
        public LoaderCacheKey getCacheKey();
    }
}

