/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.ejbc.codegen;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import weblogic.ejb.container.ejbc.codegen.GenericMethodSignature;
import weblogic.ejb.container.ejbc.codegen.MalformedMethodSignatureException;
import weblogic.ejb.container.ejbc.codegen.MethodSignatureParser;
import weblogic.utils.PlatformConstants;
import weblogic.utils.collections.AggregateKey;

public final class MethodSignature
implements PlatformConstants {
    private static final int MAX_LINE = 80;
    private boolean printThrowsClause = true;
    private GenericMethodSignature genericMethodSig;
    private String name;
    private Method method;
    private Class returnType;
    private Class[] parameterTypes;
    private Type[] typeParameters;
    private String[] parameterNames;
    private Class[] exceptionTypes;
    private int modifiers;

    MethodSignature() {
        this.parameterTypes = new Class[0];
        this.exceptionTypes = new Class[0];
    }

    public MethodSignature(Method m) {
        this.setMethod(m);
        this.setName(m.getName());
        this.setReturnType(m.getReturnType());
        this.setParameterTypes(m.getParameterTypes());
        this.parameterNames = new String[this.parameterTypes.length];
        for (int i = 0; i < this.parameterNames.length; ++i) {
            this.parameterNames[i] = "arg" + i;
        }
        this.setExceptionTypes(m.getExceptionTypes());
        this.setModifiers(m.getModifiers());
        GenericMethodSignature gms = new GenericMethodSignature(m);
        this.setGenericMethodSignature(gms);
    }

    public MethodSignature(Method m, Class pClass) {
        this.setMethod(m);
        this.setName(m.getName());
        this.setReturnType(m.getReturnType());
        this.setTypeParameters(m.getTypeParameters());
        this.setParameterTypes(m.getParameterTypes());
        this.parameterNames = new String[this.parameterTypes.length];
        for (int i = 0; i < this.parameterNames.length; ++i) {
            this.parameterNames[i] = "arg" + i;
        }
        this.setExceptionTypes(m.getExceptionTypes());
        this.setModifiers(m.getModifiers());
        GenericMethodSignature gms = new GenericMethodSignature(m, pClass);
        this.setGenericMethodSignature(gms);
    }

    public MethodSignature(String s) throws MalformedMethodSignatureException {
        this.exceptionTypes = new Class[0];
        MethodSignatureParser parser = new MethodSignatureParser(s);
        if (!parser.matchSignature(this)) {
            throw new MalformedMethodSignatureException(s);
        }
    }

    public void setPrintThrowsClause(boolean b) {
        this.printThrowsClause = b;
    }

    public Object asNameAndParamTypesKey() {
        return new AggregateKey(this.name, new AggregateKey(this.parameterTypes));
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean indentify) {
        StringBuffer sb = new StringBuffer();
        sb.append(Modifier.toString(this.modifiers & 0xFFFFFF7F & 0xFFFFFFBF)).append(" ");
        String s = sb.toString();
        int i = s.indexOf("strict ");
        if (i != -1) {
            sb.insert(i + "strict".length(), "fp");
        }
        if (this.typeParameters != null && this.typeParameters.length > 0) {
            sb.append(" <");
            sb.append(this.getTypeParametersName());
            sb.append("> ");
        }
        if (this.returnType != null) {
            sb.append(this.genericMethodSig.getParameterizedName(this.getGenericReturnType())).append(" ");
        }
        sb.append(this.name).append("(");
        for (int i2 = 0; i2 < this.parameterTypes.length; ++i2) {
            sb.append(this.genericMethodSig.getParameterizedName(this.getGenericParameterTypes()[i2])).append(" ").append(this.parameterNames[i2]);
            if (i2 >= this.parameterTypes.length - 1) continue;
            sb.append(", ");
        }
        sb.append(")");
        if (this.printThrowsClause && this.exceptionTypes.length > 0) {
            int idx = sb.length();
            sb.append(" throws ");
            Type[] genericExceptions = this.getGenericExceptionTypes();
            for (int i3 = 0; i3 < this.exceptionTypes.length; ++i3) {
                if (genericExceptions.length != this.exceptionTypes.length) {
                    sb.append(this.toJavaCode(this.exceptionTypes[i3]));
                } else {
                    sb.append(this.genericMethodSig.getParameterizedName(genericExceptions[i3]));
                }
                if (i3 >= this.exceptionTypes.length - 1) continue;
                sb.append(", ");
            }
            if (indentify && sb.length() > 80) {
                sb.insert(idx, EOL + "    ");
            }
        }
        return sb.toString();
    }

    public void setParameterNames(int idx, String name) {
        this.parameterNames[idx] = name;
    }

    public int getParameterIndex(String name) throws Exception {
        for (int i = 0; i < this.parameterNames.length; ++i) {
            if (!this.parameterNames[i].equals(name)) continue;
            return i;
        }
        throw new Exception("No param named " + name);
    }

    public Class getParameterType(String name) throws Exception {
        int idx = this.getParameterIndex(name);
        return this.parameterTypes[idx];
    }

    public String getParameterNames(int idx) {
        return this.parameterNames[idx];
    }

    public String getParameterTypesAsArgs() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.parameterTypes.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(this.genericMethodSig.getParameterizedName(this.getGenericParameterTypes()[i]));
        }
        return sb.toString();
    }

    public String getParametersAsArgs() {
        StringBuffer sb = new StringBuffer(4 * this.parameterNames.length);
        for (int i = 0; i < this.parameterNames.length; ++i) {
            sb.append(this.parameterNames[i]);
            if (i >= this.parameterNames.length - 1) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public GenericMethodSignature getGenericMethodSignature() {
        return this.genericMethodSig;
    }

    public void setGenericMethodSignature(GenericMethodSignature gms) {
        this.genericMethodSig = gms;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String s) {
        this.name = s;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method m) {
        this.method = m;
    }

    public Class getReturnType() {
        return this.returnType;
    }

    public void setReturnType(Class c) {
        this.returnType = c;
    }

    public Type getGenericReturnType() {
        return this.method.getGenericReturnType();
    }

    public String getReturnTypeName() {
        return this.genericMethodSig.getParameterizedName(this.getGenericReturnType());
    }

    public Class[] getParameterTypes() {
        return this.parameterTypes;
    }

    public void setParameterTypes(Class[] c) {
        this.parameterTypes = c;
    }

    public Type[] getGenericParameterTypes() {
        return this.method.getGenericParameterTypes();
    }

    public Type[] getTypeParameters() {
        return this.typeParameters;
    }

    public void setTypeParameters(Type[] c) {
        this.typeParameters = c;
    }

    public String getTypeParametersName() {
        if (this.typeParameters == null || this.typeParameters.length == 0) {
            return "";
        }
        StringBuffer name = new StringBuffer();
        for (int j = 0; j < this.typeParameters.length; ++j) {
            Type t = this.typeParameters[j];
            if (t instanceof TypeVariable) {
                name.append(this.genericMethodSig.getRealNameForTypeVariable(t, true));
            }
            if (j >= this.typeParameters.length - 1) continue;
            name.append(", ");
        }
        return name.toString();
    }

    public String[] getParameterNames() {
        return this.parameterNames;
    }

    public void setParameterNames(String[] s) {
        this.parameterNames = s;
    }

    public int getNumberOfParameters() {
        return this.parameterTypes.length;
    }

    public Class[] getExceptionTypes() {
        return this.exceptionTypes;
    }

    public void setExceptionTypes(Class[] c) {
        this.exceptionTypes = c;
    }

    public Type[] getGenericExceptionTypes() {
        return this.method.getGenericExceptionTypes();
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public void setModifiers(int i) {
        this.modifiers = i;
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.modifiers);
    }

    public void setPublic(boolean b) {
        if (b) {
            this.modifiers |= 1;
            this.setPrivate(false);
            this.setProtected(false);
        } else {
            this.modifiers &= 0xFFFFFFFE;
        }
    }

    public boolean isPrivate() {
        return Modifier.isPrivate(this.modifiers);
    }

    public void setPrivate(boolean b) {
        if (b) {
            this.modifiers |= 2;
            this.setPublic(false);
            this.setProtected(false);
        } else {
            this.modifiers &= 0xFFFFFFFD;
        }
    }

    public boolean isProtected() {
        return Modifier.isProtected(this.modifiers);
    }

    public void setProtected(boolean b) {
        if (b) {
            this.modifiers |= 4;
            this.setPublic(false);
            this.setPrivate(false);
        } else {
            this.modifiers &= 0xFFFFFFFB;
        }
    }

    public boolean isStatic() {
        return Modifier.isStatic(this.modifiers);
    }

    public void setStatic(boolean b) {
        this.modifiers = b ? (this.modifiers |= 8) : (this.modifiers &= 0xFFFFFFF7);
    }

    public boolean isFinal() {
        return Modifier.isFinal(this.modifiers);
    }

    public void setFinal(boolean b) {
        if (b) {
            this.modifiers |= 0x10;
            this.setAbstract(false);
        } else {
            this.modifiers &= 0xFFFFFFEF;
        }
    }

    public boolean isSynchronized() {
        return Modifier.isSynchronized(this.modifiers);
    }

    public void setSynchronized(boolean b) {
        this.modifiers = b ? (this.modifiers |= 0x20) : (this.modifiers &= 0xFFFFFFDF);
    }

    public boolean isVolatile() {
        return Modifier.isVolatile(this.modifiers);
    }

    public void setVolatile(boolean b) {
        this.modifiers = b ? (this.modifiers |= 0x40) : (this.modifiers &= 0xFFFFFFBF);
    }

    public boolean isTransient() {
        return Modifier.isTransient(this.modifiers);
    }

    public void setTransient(boolean b) {
        this.modifiers = b ? (this.modifiers |= 0x80) : (this.modifiers &= 0xFFFFFF7F);
    }

    public boolean isNative() {
        return Modifier.isNative(this.modifiers);
    }

    public void setNative(boolean b) {
        if (b) {
            this.modifiers |= 0x100;
            this.setAbstract(false);
        } else {
            this.modifiers &= 0xFFFFFEFF;
        }
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.modifiers);
    }

    public void setAbstract(boolean b) {
        if (b) {
            this.modifiers |= 0x400;
            this.setFinal(false);
            this.setNative(false);
        } else {
            this.modifiers &= 0xFFFFFBFF;
        }
    }

    public static boolean equalsMethodsBySig(MethodSignature sig1, MethodSignature sig2) {
        if (sig1 == null || sig2 == null) {
            return false;
        }
        if (sig1.getName().equals(sig2.getName())) {
            if (sig1.getNumberOfParameters() != sig2.getNumberOfParameters()) {
                return false;
            }
            if (sig1.getParameterTypesAsArgs().equals(sig2.getParameterTypesAsArgs())) {
                return true;
            }
            for (int i = 0; i < sig1.getNumberOfParameters(); ++i) {
                String name2;
                String name1 = sig1.getGenericMethodSignature().getParameterizedName(sig1.getGenericParameterTypes()[i]);
                if (name1.equals(name2 = sig2.getGenericMethodSignature().getParameterizedName(sig2.getGenericParameterTypes()[i])) || sig1.equalsParameterTypeWithClass(sig1.getGenericParameterTypes()[i], sig2.getGenericParameterTypes()[i]) || sig2.equalsParameterTypeWithClass(sig2.getGenericParameterTypes()[i], sig1.getGenericParameterTypes()[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean equalsParameterTypeWithClass(Type parameter, Type classType) {
        String pre;
        String name;
        int idx;
        return classType instanceof Class && (idx = (name = this.genericMethodSig.getParameterizedName(parameter)).indexOf("<")) > 0 && idx < name.length() - 1 && (pre = name.substring(0, idx)).equals(((Class)classType).getName());
    }

    public static void compare(MethodSignature sig1, MethodSignature sig2) {
        if (sig1.getName().equals(sig2.getName())) {
            System.out.println("name ok.");
        } else {
            System.out.println(sig1.getName() + " != " + sig2.getName());
        }
        if (sig1.getReturnType().equals(sig2.getReturnType())) {
            System.out.println("return type ok.");
        } else {
            System.out.println(sig1.getReturnType() + " != " + sig2.getReturnType());
        }
        if (sig1.getModifiers() == sig2.getModifiers()) {
            System.out.println("mods ok.");
        } else {
            System.out.println(sig1.getModifiers() + " != " + sig2.getModifiers());
        }
    }

    private String toJavaCode(Class type) {
        int arrayDim = 0;
        while (type.isArray()) {
            ++arrayDim;
            type = type.getComponentType();
        }
        StringBuffer sb = new StringBuffer(type.getName());
        for (Class<?> dc = type.getDeclaringClass(); dc != null; dc = dc.getDeclaringClass()) {
            sb.setCharAt(dc.getName().length(), '.');
        }
        for (int i = 0; i < arrayDim; ++i) {
            sb.append("[]");
        }
        return sb.toString();
    }
}

