/*
 * Decompiled with CFR 0.152.
 */
package weblogic.ejb.container.deployer;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.Remote;
import java.util.HashMap;
import java.util.Map;
import weblogic.ejb.container.deployer.RemoteBizIntfClassPreProcessor;
import weblogic.utils.classloaders.GenericClassLoader;

@Deprecated
public final class RemoteBizIntfClassLoader
extends GenericClassLoader {
    private GenericClassLoader ctxCl;
    private RemoteBizIntfClassPreProcessor rbzcpp = null;
    private String remoteBiName = null;
    private String biName = null;
    private Class<?> oldBiClass = null;
    private boolean isStubLoaded = false;
    private Map<String, Class> enhancedClasses = new HashMap<String, Class>();
    private static boolean debug = Boolean.getBoolean("weblogic.ejb.enhancement.debug");

    public RemoteBizIntfClassLoader(String biName, String remoteBiName, GenericClassLoader ctxCl) {
        super(ctxCl);
        this.ctxCl = ctxCl;
        this.remoteBiName = remoteBiName;
        this.biName = biName;
        this.rbzcpp = new RemoteBizIntfClassPreProcessor(remoteBiName, biName);
        this.addInstanceClassPreProcessor(this.rbzcpp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        Class clz;
        byte[] bytes;
        if (name.indexOf("_WLStub") > 0) {
            Class clss = this.enhancedClasses.get(name);
            if (clss != null) {
                return clss;
            }
            if (!this.isStubLoaded) {
                this.isStubLoaded = true;
                return this.ctxCl.loadClass(name);
            }
            Class<?> clz2 = this.findClass(name);
            this.enhancedClasses.put(name, clz2);
            this.isStubLoaded = false;
            return clz2;
        }
        Class<?> c = this.ctxCl.loadClass(name);
        if (c.getName().equals(this.remoteBiName)) {
            this.debug(c + "is " + this.remoteBiName + ", return it");
            return c;
        }
        if (Remote.class.isAssignableFrom(c) || Object.class.equals(c)) {
            return c;
        }
        if (name != null && name.startsWith("java.")) {
            return c;
        }
        if (!c.isInterface()) {
            return c;
        }
        if (name.equals(this.biName)) {
            this.oldBiClass = c;
            this.enhancedClasses.put(this.biName, this.oldBiClass);
        }
        if (this.oldBiClass == null || !c.isAssignableFrom(this.oldBiClass)) {
            this.debug(c + "is not super class of " + this.oldBiClass + ", return it");
            return c;
        }
        Class clss = this.enhancedClasses.get(this.remoteBiName);
        if (clss != null) {
            this.debug("got " + clss + " from " + this.enhancedClasses);
            return clss;
        }
        InputStream stream = null;
        try {
            stream = this.ctxCl.getResourceAsStream(name.replace('.', '/') + ".class");
            bytes = this.getClassBytes(stream, name);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException iOException) {}
        }
        if (name.equals(this.biName)) {
            try {
                Class<?> clz3 = this.ctxCl.loadClass(this.remoteBiName);
                this.debug("loaded " + this.remoteBiName + " on " + this.ctxCl);
                return clz3;
            }
            catch (ClassNotFoundException classNotFoundException) {
                clz = this.enhanceClass(this.biName, this.remoteBiName, bytes);
            }
        } else {
            clz = this.enhanceClass(name, name, bytes);
        }
        return clz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Class enhanceClass(String oldClassName, String newClassName, byte[] bytes) throws ClassNotFoundException {
        Class clz;
        byte[] enBytes;
        try {
            enBytes = this.doPreProcess(bytes, oldClassName);
            if (!oldClassName.equals(newClassName)) {
                clz = this.enhancedClasses.get("_pseudo_" + newClassName);
                if (clz == null) {
                    clz = this.defineClass("_pseudo_" + newClassName, enBytes, 0, enBytes.length);
                    this.enhancedClasses.put("_pseudo_" + newClassName, clz);
                }
            } else {
                clz = this.enhancedClasses.get(newClassName);
                if (clz == null) {
                    clz = this.defineClass(newClassName, enBytes, 0, enBytes.length);
                    this.enhancedClasses.put(newClassName, clz);
                }
            }
            enBytes = this.rbzcpp.postProcess();
        }
        catch (Throwable t) {
            if (debug) {
                t.printStackTrace();
            }
            throw new ClassNotFoundException(newClassName);
        }
        try {
            if (!oldClassName.equals(newClassName)) {
                GenericClassLoader t = this.ctxCl;
                synchronized (t) {
                    try {
                        Class<?> clss = this.ctxCl.loadClass(newClassName);
                        this.debug("loaded " + newClassName + " on " + this.ctxCl);
                        return clss;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        clz = this.ctxCl.defineCodeGenClass(newClassName, enBytes, null);
                        this.debug("defined " + newClassName + " on " + this.ctxCl);
                        this.enhancedClasses.put(newClassName, clz);
                    }
                }
            }
            return clz;
        }
        catch (Throwable t) {
            if (debug) {
                t.printStackTrace();
            }
            throw new ClassNotFoundException(newClassName);
        }
    }

    private byte[] getClassBytes(InputStream stream, String name) throws ClassNotFoundException {
        try {
            int count;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            while ((count = stream.read(buffer)) != -1) {
                baos.write(buffer, 0, count);
            }
            baos.close();
            byte[] array = baos.toByteArray();
            return array;
        }
        catch (Throwable t) {
            if (debug) {
                t.printStackTrace();
            }
            throw new ClassNotFoundException(name);
        }
    }

    private void debug(String log) {
        if (debug) {
            System.out.println("[" + this.getClass().getSimpleName() + "]---" + Thread.currentThread() + "---\n\t" + log);
        }
    }
}

