/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.instrumentation;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.concurrent.CopyOnWriteArrayList;
import weblogic.diagnostics.instrumentation.DelegatingMonitor;
import weblogic.diagnostics.instrumentation.DiagnosticMonitor;
import weblogic.diagnostics.instrumentation.JoinPoint;
import weblogic.diagnostics.instrumentation.MonitorLocalHolder;

public final class LocalHolder {
    public JoinPoint jp = null;
    public Object[] args = null;
    public Throwable th = null;
    public Object ret = null;
    public Object thisArg = null;
    public int monitorIndex = 0;
    public MonitorLocalHolder[] monitorHolder = null;
    public boolean argsCapture = false;
    private static CopyOnWriteArrayList<AUXHolder> auxHolders = new CopyOnWriteArrayList();

    public boolean getArgsCapture() {
        return this.argsCapture;
    }

    public Throwable getThrowable() {
        return this.th;
    }

    public Object getThisArg() {
        return this.thisArg;
    }

    public void setRet(Object ret) {
        this.ret = ret;
    }

    public void setThrowable(Throwable th) {
        this.th = th;
    }

    public void setThisArg(Object thisArg) {
        this.thisArg = thisArg;
    }

    public static LocalHolder getInstance(JoinPoint jp, DiagnosticMonitor[] monitors) {
        MonitorLocalHolder[] monitorHolders = null;
        boolean anyCapture = false;
        for (int index = 0; index < monitors.length; ++index) {
            boolean capture;
            DiagnosticMonitor mon = monitors[index];
            if (!mon.isEnabledAndNotDyeFiltered()) continue;
            if (monitorHolders == null) {
                monitorHolders = new MonitorLocalHolder[monitors.length];
            }
            monitorHolders[index] = new MonitorLocalHolder();
            monitorHolders[index].monitor = mon;
            monitorHolders[index].captureArgs = capture = mon.isArgumentsCaptureNeeded();
            if (capture) {
                anyCapture = true;
            }
            if (!(mon instanceof DelegatingMonitor)) continue;
            DelegatingMonitor delMon = (DelegatingMonitor)mon;
            monitorHolders[index].actions = delMon.getActions();
        }
        if (monitorHolders == null) {
            return null;
        }
        LocalHolder newHolder = new LocalHolder();
        newHolder.jp = jp;
        newHolder.monitorHolder = monitorHolders;
        newHolder.argsCapture = anyCapture;
        return newHolder;
    }

    public static LocalHolder getInstance(int classIndex, int jpIndex) {
        try {
            AUXHolder auxHolder = auxHolders.get(classIndex);
            if (auxHolder == null || auxHolder.joinPointAuxInfos == null) {
                return null;
            }
            if (auxHolder.useLoaderRef && auxHolder.loaderRef.get() == null) {
                return null;
            }
            JoinPointAuxInfo jpAuxInfo = (JoinPointAuxInfo)auxHolder.joinPointAuxInfos.get(jpIndex);
            if (jpAuxInfo == null) {
                return null;
            }
            return LocalHolder.getInstance(jpAuxInfo.jp, jpAuxInfo.jpMons);
        }
        catch (Throwable th) {
            return null;
        }
    }

    public static int addAUXHolder(ClassLoader loader, String className) {
        if (className == null) {
            return -1;
        }
        AUXHolder auxHolder = new AUXHolder();
        if (loader != null) {
            auxHolder.useLoaderRef = true;
            auxHolder.loaderRef = new WeakReference<ClassLoader>(loader);
        }
        auxHolder.joinPointAuxInfos = new ArrayList();
        if (!auxHolders.add(auxHolder)) {
            return -1;
        }
        return auxHolders.indexOf(auxHolder);
    }

    public static int addAuxJPMons(int classIndex, JoinPointAuxInfo jpAuxInfo) {
        if (classIndex < 0 || classIndex > auxHolders.size() || jpAuxInfo == null) {
            return -1;
        }
        AUXHolder auxHolder = auxHolders.get(classIndex);
        if (auxHolder == null) {
            return -1;
        }
        if (!auxHolder.joinPointAuxInfos.add(jpAuxInfo)) {
            return -1;
        }
        return auxHolder.joinPointAuxInfos.indexOf(jpAuxInfo);
    }

    public void resetPostBegin() {
        this.args = null;
    }

    public static class JoinPointAuxInfo {
        private JoinPoint jp = null;
        private DiagnosticMonitor[] jpMons = null;

        public void setJoinPoint(JoinPoint jp) {
            if (this.jp == null) {
                this.jp = jp;
            }
        }

        public void setJPMons(DiagnosticMonitor[] jpMons) {
            if (this.jpMons == null) {
                this.jpMons = jpMons;
            }
        }
    }

    private static class AUXHolder {
        private boolean useLoaderRef = false;
        private WeakReference<ClassLoader> loaderRef = null;
        private ArrayList<JoinPointAuxInfo> joinPointAuxInfos = null;

        private AUXHolder() {
        }
    }
}

