/*
 * Decompiled with CFR 0.152.
 */
package weblogic.diagnostics.instrumentation;

import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import weblogic.diagnostics.instrumentation.DelegatingMonitor;
import weblogic.diagnostics.instrumentation.DiagnosticAction;
import weblogic.diagnostics.instrumentation.DiagnosticActionState;
import weblogic.diagnostics.instrumentation.DiagnosticMonitor;
import weblogic.diagnostics.instrumentation.DynamicJoinPoint;
import weblogic.diagnostics.instrumentation.GatheredArgument;
import weblogic.diagnostics.instrumentation.InstrumentationSupportBase;
import weblogic.diagnostics.instrumentation.JoinPoint;
import weblogic.diagnostics.instrumentation.LocalHolder;
import weblogic.diagnostics.instrumentation.MonitorLocalHolder;
import weblogic.diagnostics.instrumentation.PointcutHandlingInfo;
import weblogic.diagnostics.instrumentation.ValueHandlingInfo;

public final class InstrumentationSupport
extends InstrumentationSupportBase {
    private static final String SUPPORT_CLASSNAME = "weblogic.diagnostics.instrumentation.rtsupport.InstrumentationSupportImpl";
    public static final String SENSITIVE_VALUE = "*****";
    private static InstrumentationSupportInterface support = InstrumentationSupport.getInstrumentationSupport();
    private static final GatheredArgument[] EMPTY_GATHERED_ARGS = new GatheredArgument[0];
    private static final String[] EMPTY_STRINGS = new String[0];
    private static final DiagnosticAction[] EMPTY_ACTIONS = new DiagnosticAction[0];

    private static InstrumentationSupportInterface getInstrumentationSupport() {
        InstrumentationSupportInterface retVal = InstrumentationSupport.getInstrumentationSupportOverride();
        if (retVal == null) {
            try {
                retVal = (InstrumentationSupportInterface)Class.forName(SUPPORT_CLASSNAME).newInstance();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InstrumentationSupportInterface getInstrumentationSupportOverride() {
        block15: {
            InstrumentationSupportInterface instrumentationSupportInterface;
            Properties props = new Properties();
            InputStream iostream = null;
            try {
                iostream = InstrumentationSupport.class.getClassLoader().getResourceAsStream("weblogic-diagnostics.properties");
                props.load(iostream);
                String overrideName = props.getProperty("weblogic.diagnostics.instrumentation.rt.SupportOverrideClassName");
                if (overrideName == null) {
                    InstrumentationSupportInterface instrumentationSupportInterface2 = null;
                    return instrumentationSupportInterface2;
                }
                InstrumentationSupportInterface retVal = null;
                instrumentationSupportInterface = retVal = (InstrumentationSupportInterface)Class.forName(overrideName).newInstance();
            }
            catch (Throwable throwable) {
                break block15;
            }
            finally {
                if (iostream != null) {
                    try {
                        iostream.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
            return instrumentationSupportInterface;
        }
        return null;
    }

    public static DiagnosticMonitor getMonitor(Class clz, String type) {
        if (support != null) {
            return support.getMonitor(clz, type);
        }
        return new PlaceholderDelegatingMonitor(type);
    }

    public static JoinPoint createJoinPoint(Class joinpointClass, String source, String className, String methodName, String methodDesc, int lineNum, Map<String, PointcutHandlingInfo> pointcutHandlingInfoMap, boolean isStatic) {
        return InstrumentationSupport.createJoinPoint(joinpointClass, source, className, methodName, methodDesc, lineNum, null, null, null, pointcutHandlingInfoMap, isStatic);
    }

    public static JoinPoint createJoinPoint(Class joinpointClass, String source, String className, String methodName, String methodDesc, int lineNum, String callerClassName, String callerMethodName, String callerMethodDesc, Map<String, PointcutHandlingInfo> pointcutHandlingInfoMap, boolean isStatic) {
        if (support != null) {
            return support.createJoinPoint(joinpointClass, source, className, methodName, methodDesc, lineNum, callerClassName, callerMethodName, callerMethodDesc, pointcutHandlingInfoMap, isStatic);
        }
        return new PlaceholderJoinPoint(joinpointClass, source, className, methodName, methodDesc, lineNum, callerClassName, callerMethodName, callerMethodDesc, pointcutHandlingInfoMap, isStatic);
    }

    public static DiagnosticMonitor getMonitor(ClassLoader loader, String className, String type) {
        if (support != null) {
            return support.getMonitor(loader, className, type);
        }
        return new PlaceholderDelegatingMonitor(type);
    }

    public static JoinPoint createJoinPoint(ClassLoader loader, String source, String className, String methodName, String methodDesc, int lineNum, String callerClassName, String callerMethodName, String callerMethodDesc, Map<String, PointcutHandlingInfo> pointcutHandlingInfoMap, boolean isStatic) {
        if (support != null) {
            return support.createJoinPoint(loader, source, className, methodName, methodDesc, lineNum, callerClassName, callerMethodName, callerMethodDesc, pointcutHandlingInfoMap, isStatic);
        }
        return new PlaceholderJoinPoint(loader, source, className, methodName, methodDesc, lineNum, callerClassName, callerMethodName, callerMethodDesc, pointcutHandlingInfoMap, isStatic);
    }

    public static void createDynamicJoinPoint(LocalHolder holder) {
        MonitorLocalHolder monHolder = holder.monitorHolder[holder.monitorIndex];
        monHolder.djp = support != null ? support.createDynamicJoinPoint(monHolder.djp == null ? holder.jp : monHolder.djp, monHolder.captureArgs ? holder.args : null, holder.ret) : new PlaceholderDynamicJoinPoint(monHolder.djp == null ? holder.jp : monHolder.djp);
    }

    public static DynamicJoinPoint createDynamicJoinPoint(JoinPoint jp, Object[] args, Object retVal) {
        if (support != null) {
            return support.createDynamicJoinPoint(jp, args, retVal);
        }
        return new PlaceholderDynamicJoinPoint(jp);
    }

    public static void process(LocalHolder holder) {
        if (support != null) {
            MonitorLocalHolder monHolder = holder.monitorHolder[holder.monitorIndex];
            support.process(monHolder.djp == null ? holder.jp : monHolder.djp, monHolder.monitor, monHolder.actions);
        }
    }

    public static void process(JoinPoint jp, DiagnosticMonitor mon, DiagnosticAction[] actions) {
        if (support != null) {
            support.process(jp, mon, actions);
        }
    }

    public static void process(JoinPoint jp, DiagnosticMonitor mon, DiagnosticAction[] actions, Throwable th) {
        if (support != null) {
            support.process(jp, mon, actions);
        }
    }

    public static void preProcess(LocalHolder holder) {
        InstrumentationSupport.applyActionStates(holder);
        if (support != null) {
            MonitorLocalHolder monHolder = holder.monitorHolder[holder.monitorIndex];
            support.preProcess(monHolder.djp == null ? holder.jp : monHolder.djp, monHolder.monitor, monHolder.actions, monHolder.states);
        }
    }

    public static void preProcess(JoinPoint jp, DiagnosticMonitor mon, DiagnosticAction[] actions, DiagnosticActionState[] states) {
        if (support != null) {
            support.preProcess(jp, mon, actions, states);
        }
    }

    public static void postProcess(LocalHolder holder) {
        if (support != null) {
            MonitorLocalHolder monHolder = holder.monitorHolder[holder.monitorIndex];
            support.postProcess(monHolder.djp == null ? holder.jp : monHolder.djp, monHolder.monitor, monHolder.actions, monHolder.states);
        }
    }

    public static void postProcess(JoinPoint jp, DiagnosticMonitor mon, DiagnosticAction[] actions, DiagnosticActionState[] states) {
        if (support != null) {
            support.postProcess(jp, mon, actions, states);
        }
    }

    public static void postProcess(JoinPoint jp, DiagnosticMonitor mon, DiagnosticAction[] actions, DiagnosticActionState[] states, Throwable th) {
        if (support != null) {
            support.postProcess(jp, mon, actions, states);
        }
    }

    public static void catchThrowable(Throwable th) {
    }

    public static PointcutHandlingInfo createPointcutHandlingInfo(ValueHandlingInfo classValueHandlingInfo, ValueHandlingInfo returnValueHandlingInfo, ValueHandlingInfo[] argumentValueHandlingInfo) {
        if (support != null) {
            return support.createPointcutHandlingInfo(classValueHandlingInfo, returnValueHandlingInfo, argumentValueHandlingInfo);
        }
        return new PlaceholderPointcutHandlingInfo(classValueHandlingInfo, returnValueHandlingInfo, argumentValueHandlingInfo);
    }

    public static ValueHandlingInfo createValueHandlingInfo(String name, String rendererClassName, boolean sensitive, boolean gathered) {
        if (support != null) {
            return support.createValueHandlingInfo(name, rendererClassName, sensitive, gathered);
        }
        return new PlaceholderValueHandlingInfo(name, rendererClassName, sensitive, gathered);
    }

    public static Map<String, PointcutHandlingInfo> makeMap(String[] names, PointcutHandlingInfo[] infos) {
        if (support != null) {
            return support.makeMap(names, infos);
        }
        return InstrumentationSupport.placeholderMakeMap(names, infos);
    }

    private static Map<String, PointcutHandlingInfo> placeholderMakeMap(String[] names, PointcutHandlingInfo[] infos) {
        if (names == null || infos == null || names.length == 0 && infos.length == 0) {
            return null;
        }
        if (names.length != infos.length) {
            return null;
        }
        HashMap<String, PointcutHandlingInfo> theMap = new HashMap<String, PointcutHandlingInfo>();
        for (int i = 0; i < names.length; ++i) {
            if (names[i] == null) {
                return null;
            }
            theMap.put(names[i], infos[i]);
        }
        return theMap;
    }

    public static Object[] toSensitive(Object[] inArr) {
        return inArr == null ? null : InstrumentationSupport.toSensitive(inArr.length);
    }

    public static Object[] toSensitive(int length) {
        return SensitiveArrayHandler.toSensitive(length);
    }

    public static boolean isSensitiveArray(Object[] testArray) {
        return SensitiveArrayHandler.isHandledSensitiveArray(testArray);
    }

    private static class SensitiveArrayHandler {
        private static final Object[] SENSITIVE_ARRAY_1 = new Object[]{"*****"};
        private static final Object[] SENSITIVE_ARRAY_2 = new Object[]{"*****", "*****"};
        private static final Object[] SENSITIVE_ARRAY_3 = new Object[]{"*****", "*****", "*****"};
        private static final Object[] SENSITIVE_ARRAY_4 = new Object[]{"*****", "*****", "*****", "*****"};
        private static final Object[] SENSITIVE_ARRAY_5 = new Object[]{"*****", "*****", "*****", "*****", "*****"};
        private static final Object[] SENSITIVE_ARRAY_6 = new Object[]{"*****", "*****", "*****", "*****", "*****", "*****"};
        private static final Object[] SENSITIVE_ARRAY_7 = new Object[]{"*****", "*****", "*****", "*****", "*****", "*****", "*****"};
        private static final Object[] SENSITIVE_ARRAY_8 = new Object[]{"*****", "*****", "*****", "*****", "*****", "*****", "*****", "*****"};
        private static final Object[] SENSITIVE_ARRAY_9 = new Object[]{"*****", "*****", "*****", "*****", "*****", "*****", "*****", "*****", "*****"};
        private static final Object[] SENSITIVE_ARRAY_10 = new Object[]{"*****", "*****", "*****", "*****", "*****", "*****", "*****", "*****", "*****", "*****"};
        private static final Object[][] SENSITIVE_ARRAYS = new Object[][]{SENSITIVE_ARRAY_1, SENSITIVE_ARRAY_2, SENSITIVE_ARRAY_3, SENSITIVE_ARRAY_4, SENSITIVE_ARRAY_5, SENSITIVE_ARRAY_6, SENSITIVE_ARRAY_7, SENSITIVE_ARRAY_8, SENSITIVE_ARRAY_9, SENSITIVE_ARRAY_10};
        private static HashMap<Integer, Object[]> extendedArrays = new HashMap();

        private SensitiveArrayHandler() {
        }

        public static Object[] toSensitive(int length) {
            if (length == 0) {
                return null;
            }
            if (length > SENSITIVE_ARRAYS.length) {
                return SensitiveArrayHandler.getExtendedArray(length);
            }
            return SENSITIVE_ARRAYS[length - 1];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static boolean isHandledSensitiveArray(Object[] testArray) {
            if (testArray == null || testArray.length == 0) {
                return false;
            }
            if (testArray.length > SENSITIVE_ARRAYS.length) {
                HashMap<Integer, Object[]> hashMap = extendedArrays;
                synchronized (hashMap) {
                    Object[] val = extendedArrays.get(testArray.length);
                    if (val == null) {
                        return false;
                    }
                    return val == testArray;
                }
            }
            return testArray == SENSITIVE_ARRAYS[testArray.length - 1];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static Object[] getExtendedArray(int length) {
            Integer key = length;
            Object[] retVal = extendedArrays.get(key);
            if (retVal != null) {
                return retVal;
            }
            HashMap<Integer, Object[]> hashMap = extendedArrays;
            synchronized (hashMap) {
                retVal = extendedArrays.get(key);
                if (retVal != null) {
                    return retVal;
                }
                retVal = new Object[length];
                for (int i = 0; i < length; ++i) {
                    retVal[i] = InstrumentationSupport.SENSITIVE_VALUE;
                }
                extendedArrays.put(key, retVal);
            }
            return retVal;
        }
    }

    private static class PlaceholderValueHandlingInfo
    implements ValueHandlingInfo {
        private String name;
        private String rendererClassName;
        private boolean sensitive;
        private boolean gathered;

        public PlaceholderValueHandlingInfo(String name, String rendererClassName, boolean sensitive, boolean gathered) {
            this.name = name;
            this.rendererClassName = rendererClassName;
            this.sensitive = sensitive;
            this.gathered = gathered;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getRendererClassName() {
            return this.rendererClassName;
        }

        @Override
        public boolean isGathered() {
            return this.gathered;
        }

        @Override
        public boolean isSensitive() {
            return this.sensitive;
        }
    }

    private static class PlaceholderPointcutHandlingInfo
    implements PointcutHandlingInfo {
        private ValueHandlingInfo classValueHandlingInfo;
        private ValueHandlingInfo returnValueHandlingInfo;
        private ValueHandlingInfo[] argumentValueHandlingInfo;

        public PlaceholderPointcutHandlingInfo(ValueHandlingInfo classValueHandlingInfo, ValueHandlingInfo returnValueHandlingInfo, ValueHandlingInfo[] argumentValueHandlingInfo) {
            this.classValueHandlingInfo = classValueHandlingInfo;
            this.returnValueHandlingInfo = returnValueHandlingInfo;
            this.argumentValueHandlingInfo = argumentValueHandlingInfo;
        }

        @Override
        public ValueHandlingInfo[] getArgumentValueHandlingInfo() {
            return this.argumentValueHandlingInfo;
        }

        @Override
        public ValueHandlingInfo getClassValueHandlingInfo() {
            return this.classValueHandlingInfo;
        }

        @Override
        public ValueHandlingInfo getReturnValueHandlingInfo() {
            return this.returnValueHandlingInfo;
        }
    }

    private static class PlaceholderDynamicJoinPoint
    extends PlaceholderJoinPoint
    implements DynamicJoinPoint {
        private JoinPoint jp;
        private static Object[] placeHolderArgs = new Object[0];

        PlaceholderDynamicJoinPoint(JoinPoint jp) {
            this.jp = jp;
        }

        @Override
        public Object[] getArguments() {
            return placeHolderArgs;
        }

        @Override
        public JoinPoint getDelegate() {
            return this.jp;
        }

        @Override
        public Object getReturnValue() {
            return "";
        }

        @Override
        public boolean isReturnGathered() {
            return false;
        }

        @Override
        public GatheredArgument[] getGatheredArguments() {
            return EMPTY_GATHERED_ARGS;
        }
    }

    private static class PlaceholderJoinPoint
    implements JoinPoint {
        private static final String UNKNOWN = "Unknown";
        private WeakReference<ClassLoader> loaderRef = null;
        private Class joinpointClass = null;
        private String source = "Unknown";
        private String className = "Unknown";
        private String methodName = "Unknown";
        private String methodDesc = "Unknown";
        private String callerClassName = "Unknown";
        private String callerMethodName = "Unknown";
        private String callerMethodDesc = "Unknown";
        private int lineNum = 0;
        private Map<String, PointcutHandlingInfo> pointcutHandlingInfoMap = null;
        private boolean isStatic = true;

        public PlaceholderJoinPoint() {
        }

        public PlaceholderJoinPoint(Class joinpointClass, String source, String className, String methodName, String methodDesc, int lineNum, String callerClassName, String callerMethodName, String callerMethodDesc, Map<String, PointcutHandlingInfo> pointcutHandlingInfoMap, boolean isStatic) {
            this.joinpointClass = joinpointClass;
            this.source = source;
            this.className = className;
            this.methodName = methodName;
            this.methodDesc = methodDesc;
            this.lineNum = lineNum;
            this.callerClassName = callerClassName;
            this.callerMethodName = callerMethodName;
            this.callerMethodDesc = callerMethodDesc;
            this.pointcutHandlingInfoMap = pointcutHandlingInfoMap;
            this.isStatic = isStatic;
        }

        public PlaceholderJoinPoint(ClassLoader loader, String source, String className, String methodName, String methodDesc, int lineNum, String callerClassName, String callerMethodName, String callerMethodDesc, Map<String, PointcutHandlingInfo> pointcutHandlingInfoMap, boolean isStatic) {
            if (loader != null) {
                this.loaderRef = new WeakReference<ClassLoader>(loader);
            }
            this.source = source;
            this.className = className;
            this.methodName = methodName;
            this.methodDesc = methodDesc;
            this.lineNum = lineNum;
            this.callerClassName = callerClassName;
            this.callerMethodName = callerMethodName;
            this.callerMethodDesc = callerMethodDesc;
            this.pointcutHandlingInfoMap = pointcutHandlingInfoMap;
            this.isStatic = isStatic;
        }

        public Class getJoinpointClass() {
            if (this.joinpointClass != null) {
                return this.joinpointClass;
            }
            if (this.className == null) {
                return null;
            }
            try {
                ClassLoader loader;
                ClassLoader classLoader = loader = this.loaderRef == null ? null : (ClassLoader)this.loaderRef.get();
                if (this.loaderRef != null && loader == null) {
                    return null;
                }
                this.joinpointClass = Class.forName(this.className, true, loader);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return this.joinpointClass;
        }

        @Override
        public String getClassName() {
            return this.className;
        }

        @Override
        public int getLineNumber() {
            return this.lineNum;
        }

        @Override
        public String getMethodDescriptor() {
            return this.methodDesc;
        }

        @Override
        public String getMethodName() {
            return this.methodName;
        }

        @Override
        public String getModuleName() {
            return UNKNOWN;
        }

        @Override
        public String getSourceFile() {
            return this.source;
        }

        @Override
        public boolean isReturnGathered(String monitorType) {
            return false;
        }

        @Override
        public GatheredArgument[] getGatheredArguments(String monitorType) {
            return EMPTY_GATHERED_ARGS;
        }

        @Override
        public Map<String, PointcutHandlingInfo> getPointcutHandlingInfoMap() {
            return this.pointcutHandlingInfoMap;
        }

        @Override
        public boolean isStatic() {
            return this.isStatic;
        }

        @Override
        public String getCallerClassName() {
            return this.callerClassName;
        }

        @Override
        public String getCallerMethodName() {
            return this.callerMethodName;
        }

        @Override
        public String getCallerMethodDescriptor() {
            return this.callerMethodDesc;
        }
    }

    private static class PlaceholderDelegatingMonitor
    implements DelegatingMonitor {
        private String type;

        PlaceholderDelegatingMonitor(String type) {
            this.type = type;
        }

        @Override
        public String getAttribute(String attributeName) {
            return null;
        }

        @Override
        public String[] getAttributeNames() {
            return EMPTY_STRINGS;
        }

        @Override
        public String getDescription() {
            return null;
        }

        @Override
        public String getName() {
            return this.type;
        }

        @Override
        public String getType() {
            return this.type;
        }

        @Override
        public boolean isArgumentsCaptureNeeded() {
            return false;
        }

        @Override
        public boolean isComponentScopeAllowed() {
            return true;
        }

        @Override
        public boolean isEnabled() {
            return false;
        }

        @Override
        public boolean isEnabledAndNotDyeFiltered() {
            return false;
        }

        @Override
        public boolean isServerScopeAllowed() {
            return true;
        }

        @Override
        public void setAttribute(String attributeName, String attributeValue) {
        }

        @Override
        public void setDescription(String description) {
        }

        @Override
        public void setEnabled(boolean enable) {
        }

        @Override
        public void setName(String name) {
        }

        @Override
        public long getDyeMask() {
            return 0L;
        }

        @Override
        public boolean isDyeFilteringEnabled() {
            return false;
        }

        @Override
        public void setDyeFilteringEnabled(boolean enable) {
        }

        @Override
        public void setDyeMask(long dye_mask) {
        }

        @Override
        public void addAction(DiagnosticAction action) {
        }

        @Override
        public DiagnosticAction[] getActions() {
            return EMPTY_ACTIONS;
        }

        @Override
        public String[] getCompatibleActionTypes() {
            return EMPTY_STRINGS;
        }

        @Override
        public void removeAction(DiagnosticAction action) {
        }

        @Override
        public String[] getIncludes() {
            return EMPTY_STRINGS;
        }

        @Override
        public void setIncludes(String[] includes) {
        }

        @Override
        public String[] getExcludes() {
            return EMPTY_STRINGS;
        }

        @Override
        public void setExcludes(String[] excludes) {
        }

        @Override
        public boolean isServerManaged() {
            return false;
        }

        @Override
        public void setServerManaged(boolean serverManaged) {
        }

        @Override
        public String getDiagnosticVolume() {
            return "Off";
        }

        @Override
        public void setDiagnosticVolume(String diagnosticVolume) {
        }

        @Override
        public String getEventClassName() {
            return null;
        }

        @Override
        public Class getEventClass() {
            return null;
        }

        @Override
        public void setEventClassName(String eventClassName) {
        }
    }

    public static interface InstrumentationSupportInterface {
        public DiagnosticMonitor getMonitor(Class var1, String var2);

        public DiagnosticMonitor getMonitor(ClassLoader var1, String var2, String var3);

        public void process(JoinPoint var1, DiagnosticMonitor var2, DiagnosticAction[] var3);

        public void preProcess(JoinPoint var1, DiagnosticMonitor var2, DiagnosticAction[] var3, DiagnosticActionState[] var4);

        public void postProcess(JoinPoint var1, DiagnosticMonitor var2, DiagnosticAction[] var3, DiagnosticActionState[] var4);

        public JoinPoint createJoinPoint(Class var1, String var2, String var3, String var4, String var5, int var6, String var7, String var8, String var9, Map<String, PointcutHandlingInfo> var10, boolean var11);

        public JoinPoint createJoinPoint(ClassLoader var1, String var2, String var3, String var4, String var5, int var6, String var7, String var8, String var9, Map<String, PointcutHandlingInfo> var10, boolean var11);

        public DynamicJoinPoint createDynamicJoinPoint(JoinPoint var1, Object[] var2, Object var3);

        public PointcutHandlingInfo createPointcutHandlingInfo(ValueHandlingInfo var1, ValueHandlingInfo var2, ValueHandlingInfo[] var3);

        public ValueHandlingInfo createValueHandlingInfo(String var1, String var2, boolean var3, boolean var4);

        public Map<String, PointcutHandlingInfo> makeMap(String[] var1, PointcutHandlingInfo[] var2);
    }
}

