/*
 * Decompiled with CFR 0.152.
 */
package weblogic.descriptor.internal;

public class DescriptorBeanClassName {
    public static final String RUNTIME_SUFFIX = "Impl";
    public static final String RUNTIME_PACKAGE = "beanimpl";

    public static String toImpl(String interfaceName, boolean editable) {
        return DescriptorBeanClassName.toImpl(interfaceName, editable, Thread.currentThread().getContextClassLoader());
    }

    public static String toImpl(String interfaceName, boolean editable, ClassLoader loader) {
        String implName = interfaceName + RUNTIME_SUFFIX;
        int lastPeriodPosition = implName.lastIndexOf(46);
        if (lastPeriodPosition > -1 && lastPeriodPosition < implName.length()) {
            String packageName = implName.substring(0, lastPeriodPosition + 1) + RUNTIME_PACKAGE;
            String className = implName.substring(lastPeriodPosition + 1);
            String otherImplName = packageName + '.' + className;
            try {
                Class.forName(otherImplName, false, loader);
                implName = otherImplName;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return implName;
    }

    public static String toImpl(String interfaceName) {
        return DescriptorBeanClassName.toImpl(interfaceName, false);
    }

    public static String toEditableImpl(String interfaceName) {
        return DescriptorBeanClassName.toImpl(interfaceName, true);
    }

    public static String toInterface(String implName) {
        String suffix = RUNTIME_SUFFIX;
        return implName.substring(0, implName.length() - suffix.length());
    }
}

