/*
 * Decompiled with CFR 0.152.
 */
package weblogic.descriptor;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.util.StreamReaderDelegate;
import weblogic.utils.XXEUtils;

public class DescriptorReader
extends StreamReaderDelegate
implements XMLStreamReader {
    Map namespaceMap = new HashMap();
    private boolean modified = false;

    public DescriptorReader(InputStream _in) throws XMLStreamException {
        super(XXEUtils.createXMLInputFactoryInstance().createXMLStreamReader(_in));
    }

    @Override
    public String getNamespaceURI() {
        String uri = super.getNamespaceURI();
        String override = (String)this.namespaceMap.get(uri);
        if (override != null) {
            this.setModified(true);
            uri = override;
        }
        return uri;
    }

    @Override
    public String getNamespaceURI(int index) {
        String uri = super.getNamespaceURI(index);
        String override = (String)this.namespaceMap.get(uri);
        if (override != null) {
            this.setModified(true);
            uri = override;
        }
        return uri;
    }

    @Override
    public String getNamespaceURI(String prefix) {
        String result = super.getNamespaceURI(prefix);
        result = this.mapNamespace(result);
        return result;
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        NamespaceContext result = super.getNamespaceContext();
        return new NamespaceContextWrapper(result);
    }

    public void addNamespaceMapping(String from, String to) {
        this.namespaceMap.put(from, to);
    }

    public boolean isModified() {
        return this.modified;
    }

    protected void setModified(boolean modified) {
        this.modified = modified;
    }

    private String mapNamespace(String result) {
        if (result == null) {
            return null;
        }
        for (String next : this.namespaceMap.keySet()) {
            if (!result.equals(next)) continue;
            result = (String)this.namespaceMap.get(next);
            this.setModified(true);
            break;
        }
        return result;
    }

    private class NamespaceContextWrapper
    implements NamespaceContext {
        NamespaceContext nc;

        public NamespaceContextWrapper(NamespaceContext _nc) {
            this.nc = _nc;
        }

        @Override
        public String getNamespaceURI(String key) {
            String result = DescriptorReader.this.mapNamespace(this.nc.getNamespaceURI(key));
            return result;
        }

        @Override
        public String getPrefix(String key) {
            String result = DescriptorReader.this.mapNamespace(this.nc.getPrefix(key));
            return result;
        }

        public Iterator getPrefixes(String key) {
            return this.nc.getPrefixes(key);
        }
    }
}

