/*
 * Decompiled with CFR 0.152.
 */
package weblogic.descriptor;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import javax.xml.stream.XMLStreamException;
import weblogic.diagnostics.debug.DebugLogger;

public final class DescriptorCache {
    private static DebugLogger debug = DebugLogger.getDebugLogger("DebugDescriptor");
    private static final String CRC_FILE = "crc.ser";
    private static final String DES_FILE = "des.ser";
    private static final String VER_FILE = "ver.ser";
    private static final DescriptorCache SINGLETON = new DescriptorCache();
    private static final Class fileOwnerFixerClass = DescriptorCache.getFileOwnerClass();
    private static final Method addPathMethod = DescriptorCache.getAddPathMethod();

    private DescriptorCache() {
    }

    public static DescriptorCache getInstance() {
        return SINGLETON;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long computeCRC(IOHelper h) throws IOException {
        CRC32 crc = new CRC32();
        CheckedInputStream cis = null;
        try {
            cis = new CheckedInputStream(h.openInputStream(), crc);
            if (cis.markSupported()) {
                cis.mark(Integer.MAX_VALUE);
            }
            byte[] buf = new byte[1024];
            int i = 0;
            while (i != -1) {
                i = cis.read(buf);
            }
            long l = crc.getValue();
            return l;
        }
        finally {
            if (cis != null) {
                try {
                    if (cis.markSupported()) {
                        cis.reset();
                    }
                }
                catch (IOException iOException) {}
                try {
                    cis.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long readCRC(File crcFile) throws IOException {
        InputStream ois = null;
        try {
            ois = new ObjectInputStream(new FileInputStream(crcFile));
            if (ois.markSupported()) {
                ois.mark(Integer.MAX_VALUE);
            }
            long l = ((ObjectInputStream)ois).readLong();
            return l;
        }
        finally {
            if (ois != null) {
                try {
                    if (ois.markSupported()) {
                        ois.reset();
                    }
                }
                catch (IOException iOException) {}
                try {
                    ((ObjectInputStream)ois).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readVersion(File verFile) throws IOException, ClassNotFoundException {
        InputStream ois = null;
        try {
            ois = new ObjectInputStream(new FileInputStream(verFile));
            if (ois.markSupported()) {
                ois.mark(Integer.MAX_VALUE);
            }
            String string = (String)((ObjectInputStream)ois).readObject();
            return string;
        }
        finally {
            if (ois != null) {
                try {
                    if (ois.markSupported()) {
                        ois.reset();
                    }
                }
                catch (IOException iOException) {}
                try {
                    ((ObjectInputStream)ois).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private Object findMatchInCache(File dir, long CRC, IOHelper helper) throws IOException {
        File crcFile = new File(dir, CRC_FILE);
        if (!crcFile.exists()) {
            if (debug.isDebugEnabled()) {
                debug.debug("** CrcFile wasn't there: " + crcFile);
            }
            return null;
        }
        if (debug.isDebugEnabled()) {
            debug.debug("** found CRC file");
        }
        long cachedCRC = this.readCRC(crcFile);
        File desFile = new File(dir, DES_FILE);
        if (cachedCRC != CRC || !desFile.exists()) {
            if (debug.isDebugEnabled()) {
                debug.debug("** descriptor has changed");
            }
            crcFile.delete();
            if (desFile.exists()) {
                desFile.delete();
            }
            return null;
        }
        try {
            return helper.readCachedBean(desFile);
        }
        catch (IOException e) {
            if (debug.isDebugEnabled()) {
                debug.debug("** Exception from helper", e);
                e.printStackTrace();
            }
            crcFile.delete();
            desFile.delete();
            return null;
        }
    }

    private boolean findMatchingCRCInCache(File dir, long CRC, IOHelper helper) throws IOException {
        long cachedCRC;
        File crcFile = new File(dir, CRC_FILE);
        if (!crcFile.exists()) {
            if (debug.isDebugEnabled()) {
                debug.debug("** CrcFile wasn't there: " + crcFile);
            }
            return false;
        }
        if (debug.isDebugEnabled()) {
            debug.debug("** found CRC file");
        }
        return (cachedCRC = this.readCRC(crcFile)) == CRC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToCache(Object o, File dir, long CRC) throws IOException {
        if (debug.isDebugEnabled()) {
            debug.debug("** writeToCache " + o.getClass().getName());
        }
        dir.mkdirs();
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(new FileOutputStream(new File(dir, CRC_FILE)));
            oos.writeLong(CRC);
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException iOException) {}
            }
            oos = null;
        }
        try {
            oos = new ObjectOutputStream(new FileOutputStream(new File(dir, DES_FILE)));
            oos.writeObject(o);
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static Class getFileOwnerClass() {
        try {
            return Class.forName("weblogic.t3.srvr.FileOwnerFixer");
        }
        catch (ClassNotFoundException ignore) {
            return null;
        }
    }

    private static Method getAddPathMethod() {
        if (fileOwnerFixerClass != null) {
            try {
                return fileOwnerFixerClass.getMethod("addPathJDK6", File.class);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private static void addPath(File f) {
        if (fileOwnerFixerClass != null) {
            try {
                addPathMethod.invoke(null, f);
            }
            catch (IllegalAccessException ignoredSincePublic) {
                throw new RuntimeException(ignoredSincePublic);
            }
            catch (IllegalArgumentException ignoreSincePassingRightArgument) {
                throw new RuntimeException(ignoreSincePassingRightArgument);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeCRCToCache(File dir, long CRC) throws IOException {
        if (debug.isDebugEnabled()) {
            debug.debug("** writeCRCToCache " + CRC);
        }
        DescriptorCache.addPath(dir);
        dir.mkdirs();
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(new FileOutputStream(new File(dir, CRC_FILE)));
            oos.writeLong(CRC);
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException iOException) {}
            }
            oos = null;
        }
    }

    public boolean hasChanged(File cacheDir, IOHelper helper) {
        try {
            long cachedCRC;
            long CRC;
            File crcFile = new File(cacheDir, CRC_FILE);
            try {
                CRC = this.computeCRC(helper);
            }
            catch (Exception e) {
                return true;
            }
            if (debug.isDebugEnabled()) {
                debug.debug("** crc is " + CRC);
            }
            if (!crcFile.exists()) {
                if (debug.isDebugEnabled()) {
                    debug.debug("** CrcFile wasn't there: " + crcFile);
                }
                this.writeCRCToCache(cacheDir, CRC);
                return true;
            }
            if (debug.isDebugEnabled()) {
                debug.debug("** found CRC file");
            }
            try {
                cachedCRC = this.readCRC(crcFile);
            }
            catch (Exception e) {
                return true;
            }
            if (cachedCRC != CRC) {
                this.writeCRCToCache(cacheDir, CRC);
            }
            return cachedCRC != CRC;
        }
        catch (Throwable e) {
            return true;
        }
    }

    public void removeCRC(File cacheDir) {
        try {
            File crcFile = new File(cacheDir, CRC_FILE);
            if (crcFile.exists()) {
                crcFile.delete();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object parseXML(File cacheDir, IOHelper helper) throws IOException, XMLStreamException {
        long CRC = this.computeCRC(helper);
        if (debug.isDebugEnabled()) {
            debug.debug("** crc is " + CRC);
        }
        Object o = null;
        if (helper.useCaching()) {
            o = this.findMatchInCache(cacheDir, CRC, helper);
            if (o != null) {
                if (debug.isDebugEnabled()) {
                    debug.debug("** CACHE Hit");
                }
                return o;
            }
            if (debug.isDebugEnabled()) {
                debug.debug("** cache miss");
            }
        }
        InputStream is = null;
        try {
            is = helper.openInputStream();
            o = helper.parseXML(is);
            if (debug.isDebugEnabled()) {
                debug.debug("** HELPER.parseXML returned " + o.getClass().getName());
            }
            if (helper.useCaching()) {
                this.writeToCache(o, cacheDir, CRC);
                if (debug.isDebugEnabled()) {
                    debug.debug("** Wrote descriptor to " + cacheDir);
                }
            }
            Object object = o;
            return object;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public boolean hasVersionChanged(File cacheDir, String strVersion) {
        try {
            String cachedVersion;
            File verFile = new File(cacheDir, VER_FILE);
            if (debug.isDebugEnabled()) {
                debug.debug("** ver is " + strVersion);
            }
            if (!verFile.exists()) {
                if (debug.isDebugEnabled()) {
                    debug.debug("** VerFile wasn't there: " + verFile);
                }
                return true;
            }
            if (debug.isDebugEnabled()) {
                debug.debug("** found VER file");
            }
            try {
                cachedVersion = this.readVersion(verFile);
            }
            catch (Exception e) {
                return true;
            }
            return !strVersion.equals(cachedVersion);
        }
        catch (Throwable e) {
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeVersion(File dir, String strVersion) {
        if (debug.isDebugEnabled()) {
            debug.debug("** writeVersion " + strVersion);
        }
        dir.mkdirs();
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(new FileOutputStream(new File(dir, VER_FILE)));
            oos.writeObject(strVersion);
        }
        catch (Exception exception) {
        }
        finally {
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException iOException) {}
            }
            oos = null;
        }
    }

    public void removeVersion(File cacheDir) {
        try {
            File verFile = new File(cacheDir, VER_FILE);
            if (verFile.exists()) {
                verFile.delete();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static interface IOHelper {
        public InputStream openInputStream() throws IOException;

        public Object readCachedBean(File var1) throws IOException;

        public Object parseXML(InputStream var1) throws IOException, XMLStreamException;

        public boolean useCaching();
    }
}

