/*
 * Decompiled with CFR 0.152.
 */
package weblogic.deployment.jms;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.regex.Matcher;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import weblogic.deployment.jms.ForeignJMSServerAware;
import weblogic.deployment.jms.ForeignOpaqueTag;
import weblogic.deployment.jms.JMSPoolLogger;
import weblogic.deployment.jms.ObjectBasedSecurityAware;
import weblogic.j2ee.descriptor.wl.ForeignConnectionFactoryBean;
import weblogic.j2ee.descriptor.wl.ForeignJNDIObjectBean;
import weblogic.j2ee.descriptor.wl.ForeignServerBean;
import weblogic.j2ee.descriptor.wl.PropertyBean;
import weblogic.jndi.OpaqueReference;
import weblogic.jndi.internal.JNDIEnvironment;
import weblogic.jndi.internal.JNDIUtils;
import weblogic.kernel.Kernel;
import weblogic.kernel.KernelStatus;
import weblogic.rmi.internal.RMIEnvironment;
import weblogic.security.SubjectUtils;
import weblogic.security.WLSPrincipals;
import weblogic.security.acl.internal.AuthenticatedSubject;
import weblogic.security.subject.AbstractSubject;
import weblogic.security.subject.SubjectManager;
import weblogic.security.utils.RequestSigner;

public class ForeignOpaqueReference
implements ForeignOpaqueTag,
OpaqueReference,
Serializable {
    static final long serialVersionUID = 4404892619941441265L;
    private static final transient AbstractSubject KERNEL_ID = (AbstractSubject)AccessController.doPrivileged(SubjectManager.getKernelIdentityAction());
    private boolean isFactory = false;
    private String username;
    private String password;
    private String connectionHealthChecking = "enabled";
    private Hashtable jndiEnvironment;
    private String remoteJNDIName;
    private String signature;
    private String timestamp;
    private static String AQJMS_ICF = "oracle.jms.AQjmsInitialContextFactory";
    private static String AQJMS_QPREFIX = "Queues/";
    private static String AQJMS_TPREFIX = "Topics/";
    private transient Object cachedReferent;
    private static final String MACROS_ENABLED_PROP = "weblogic.jms.foreign.EnableMacros";
    private static final boolean MACROS_ENABLED = ForeignOpaqueReference.macrosEnabled();
    private static final String SERVER_NAME_MACRO = "_SVNAME_";
    private static final String SERVER_NUM_MACRO = "_SVNUM_";

    public ForeignOpaqueReference() {
    }

    public ForeignOpaqueReference(ForeignServerBean foreignServerBean, ForeignJNDIObjectBean fJndiObject) {
        byte[] credential;
        String url;
        String icf;
        PropertyBean[] properties;
        this.remoteJNDIName = fJndiObject.getRemoteJNDIName();
        if (fJndiObject instanceof ForeignConnectionFactoryBean) {
            this.isFactory = true;
            this.username = ((ForeignConnectionFactoryBean)fJndiObject).getUsername();
            this.password = ((ForeignConnectionFactoryBean)fJndiObject).getPassword();
            this.connectionHealthChecking = ((ForeignConnectionFactoryBean)fJndiObject).getConnectionHealthChecking();
        }
        if ((properties = foreignServerBean.getJNDIProperties()) != null && properties.length != 0) {
            this.jndiEnvironment = new Hashtable(properties.length);
            for (int i = 0; i < properties.length; ++i) {
                this.jndiEnvironment.put(properties[i].getKey(), properties[i].getValue());
            }
        }
        if (this.jndiEnvironment == null) {
            this.jndiEnvironment = new Hashtable(3);
        }
        if ((icf = foreignServerBean.getInitialContextFactory()) != null && icf.trim().length() != 0 && !icf.equals("weblogic.jndi.WLInitialContextFactory")) {
            this.jndiEnvironment.put("java.naming.factory.initial", icf);
        }
        if ((url = foreignServerBean.getConnectionURL()) != null && url.trim().length() != 0) {
            this.jndiEnvironment.put("java.naming.provider.url", url);
        }
        if ((credential = foreignServerBean.getJNDIPropertiesCredentialEncrypted()) != null) {
            AbstractSubject kernelId = (AbstractSubject)AccessController.doPrivileged(SubjectManager.getKernelIdentityAction());
            String cString = new String(JNDIEnvironment.getJNDIEnvironment().encryptionHelperDecrypt(credential, (AuthenticatedSubject)kernelId));
            JNDIEnvironment.getJNDIEnvironment().encryptionHelperClear(credential);
            if (cString.trim().length() > 0) {
                this.jndiEnvironment.put("java.naming.security.credentials", cString);
            }
        }
        if (this.jndiEnvironment.size() == 0) {
            this.jndiEnvironment = null;
        }
        if (this.jndiEnvironment != null && this.jndiEnvironment.get("java.naming.provider.url") != null && Kernel.isServer()) {
            String providerURL = (String)this.jndiEnvironment.get("java.naming.provider.url");
            this.timestamp = "" + System.currentTimeMillis();
            this.signature = RequestSigner.getInstance().signRequestURL(providerURL, this.timestamp);
        } else {
            this.timestamp = null;
            this.signature = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getReferent(Name name, Context ctx) throws NamingException {
        Object retVal;
        block21: {
            Object subjectUserName;
            InitialContext context;
            AbstractSubject originalSubject = SubjectManager.getSubjectManager().getCurrentSubject(KERNEL_ID);
            if (this.jndiEnvironment == null) {
                context = new InitialContext();
            } else {
                String providerURL;
                if (this.jndiEnvironment.get("java.naming.factory.initial") == null) {
                    this.jndiEnvironment.put("java.naming.factory.initial", "weblogic.jndi.WLInitialContextFactory");
                }
                if (!((providerURL = (String)this.jndiEnvironment.get("java.naming.provider.url")) == null || this.signature != null && this.timestamp != null && RequestSigner.getInstance().verifyRequestURL(providerURL, this.signature, this.timestamp))) {
                    throw new NamingException("Invalid ForeignOpaqueReference signature");
                }
                context = new InitialContext(this.jndiEnvironment);
            }
            AbstractSubject subject = SubjectManager.getSubjectManager().getCurrentSubject(KERNEL_ID);
            if (KernelStatus.isServer()) {
                subjectUserName = SubjectUtils.getUsername(subject.getSubject());
                String originalSubjectUserName = SubjectUtils.getUsername(originalSubject.getSubject());
                if (WLSPrincipals.isKernelUsername((String)subjectUserName)) {
                    subject = WLSPrincipals.isKernelUsername(originalSubjectUserName) ? SubjectManager.getSubjectManager().getAnonymousSubject() : originalSubject;
                }
                String url = null;
                if (this.jndiEnvironment != null && this.jndiEnvironment.get("java.naming.security.principal") == null && (url = (String)this.jndiEnvironment.get("java.naming.provider.url")) != null && this.jndiEnvironment.get("java.naming.factory.initial") != null && ((String)this.jndiEnvironment.get("java.naming.factory.initial")).indexOf("weblogic") != -1) {
                    try {
                        if (RMIEnvironment.getEnvironment().isRemoteDomain(url)) {
                            subject = SubjectManager.getSubjectManager().getAnonymousSubject();
                        }
                    }
                    catch (IOException ioe) {
                        throw new NamingException(ioe.getMessage());
                    }
                }
            }
            SubjectManager.getSubjectManager().pushSubject(KERNEL_ID, subject);
            try {
                String providerURL;
                if (this.jndiEnvironment != null && AQJMS_ICF.equals(this.jndiEnvironment.get("java.naming.factory.initial")) && this.remoteJNDIName != null && (this.remoteJNDIName.startsWith(AQJMS_QPREFIX) || this.remoteJNDIName.startsWith(AQJMS_TPREFIX))) {
                    subjectUserName = this;
                    synchronized (subjectUserName) {
                        if (this.cachedReferent == null) {
                            this.cachedReferent = context.lookup(ForeignOpaqueReference.evalMacros(this.remoteJNDIName));
                        }
                    }
                    retVal = this.cachedReferent;
                    break block21;
                }
                String string = providerURL = this.jndiEnvironment != null ? (String)this.jndiEnvironment.get("java.naming.provider.url") : null;
                if (providerURL == null && this.remoteJNDIName != null && !JNDIUtils.isValidJndiScheme(new CompositeName(this.remoteJNDIName))) {
                    throw new NamingException("JNDI name is invalid - " + this.remoteJNDIName);
                }
                retVal = context.lookup(ForeignOpaqueReference.evalMacros(this.remoteJNDIName));
            }
            finally {
                SubjectManager.getSubjectManager().popSubject(KERNEL_ID);
                context.close();
            }
        }
        if (retVal instanceof ObjectBasedSecurityAware && ((ObjectBasedSecurityAware)retVal).isOBSEnabled()) {
            throw new NamingException(JMSPoolLogger.logUnsupportedConnectionFactoryReferencedByForeignSeverLoggable().getMessage());
        }
        if (retVal instanceof ForeignJMSServerAware) {
            ((ForeignJMSServerAware)retVal).setReferencedByFS(true);
        }
        return retVal;
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("ForeignOpaqueReference: target=\"");
        buf.append(this.remoteJNDIName);
        buf.append('\"');
        if (this.jndiEnvironment != null) {
            Enumeration allProps = this.jndiEnvironment.keys();
            while (allProps.hasMoreElements()) {
                String key = (String)allProps.nextElement();
                String value = (String)this.jndiEnvironment.get(key);
                buf.append(' ');
                buf.append(key);
                buf.append('=');
                buf.append(value);
            }
        }
        return buf.toString();
    }

    @Override
    public boolean isFactory() {
        return this.isFactory;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    public String getConnectionHealthChecking() {
        return this.connectionHealthChecking;
    }

    @Override
    public Hashtable getJNDIEnvironment() {
        return this.jndiEnvironment;
    }

    public String getRemoteJNDIName() {
        return this.remoteJNDIName;
    }

    private static String evalMacros(String jndiName) throws NamingException {
        if (!MACROS_ENABLED || jndiName == null || !jndiName.contains(SERVER_NAME_MACRO) && !jndiName.contains(SERVER_NUM_MACRO)) {
            return jndiName;
        }
        String sName = ForeignOpaqueReference.getServerName();
        String sNum = "";
        for (int i = sName.length() - 1; i >= 0 && Character.isDigit(sName.charAt(i)); --i) {
            sNum = sName.charAt(i) + sNum;
        }
        if (jndiName.contains(SERVER_NUM_MACRO) && sNum.length() == 0) {
            throw new NamingException("Cannot resolve Foreign JMS Destination '" + jndiName + "' on server '" + sName + "', the macro '" + SERVER_NUM_MACRO + "' requires the server name to have a numeric suffix.");
        }
        sName = Matcher.quoteReplacement(sName);
        String ret = jndiName.replaceAll(SERVER_NAME_MACRO, sName).replaceAll(SERVER_NUM_MACRO, sNum);
        return ret;
    }

    private static boolean macrosEnabled() {
        try {
            return System.getProperty(MACROS_ENABLED_PROP, "false").equals("true");
        }
        catch (Throwable t) {
            return false;
        }
    }

    private static String getServerName() throws NamingException {
        if (!KernelStatus.isServer()) {
            throw new NamingException("Cannot determine server name on a client.");
        }
        try {
            Class<?> mgmtService = Class.forName("weblogic.management.provider.ManagementService");
            Class<?> authSubj = Class.forName("weblogic.security.acl.internal.AuthenticatedSubject");
            Method rtAccess = mgmtService.getMethod("getRuntimeAccess", authSubj);
            Object returnObject = rtAccess.invoke(null, KERNEL_ID);
            Class<?> rtAccessClass = Class.forName("weblogic.management.provider.RuntimeAccess");
            Method getServerNameMethod = rtAccessClass.getMethod("getServerName", new Class[0]);
            Object returnObject1 = getServerNameMethod.invoke(returnObject, new Object[0]);
            return (String)returnObject1;
        }
        catch (Throwable t) {
            NamingException ne = new NamingException("Cannot determine server name");
            ne.initCause(t);
            throw ne;
        }
    }
}

