/*
 * Decompiled with CFR 0.152.
 */
package weblogic.common.internal;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import weblogic.common.internal.PackageInfo;
import weblogic.common.internal.VersioningError;
import weblogic.utils.jars.ManifestManager;

public class VersionInfo
extends PackageInfo
implements Serializable {
    private static final long serialVersionUID = -7556401008896489922L;
    private static final String BEA_VENDOR_STRING = "BEA Systems";
    private static final String ORACLE_VENDOR_STRING = "Oracle";
    private static final String[] SUPPORTED_PREFIXES = new String[]{"WebLogic", "AquaLogic", "Kodo", "Oracle"};
    private static String defaultImplVendor = "BEA Systems";
    private static String defaultImplTitle = "Unknown";
    private static String defaultImplVersion = "Unknown";
    private static String defaultVersionString = "Unknown";
    private static int defaultMajor = 1;
    private static int defaultMinor = 0;
    private static int defaultSP = 0;
    private static int defaultPatch = 0;
    private static int defaultPatchUpdate = 0;
    private static String DEFAULT_PROTOCOL_PRODUCT_ID = "WebLogic Server";
    private static boolean searchClasspath = false;
    private static PackageInfo[] classpathPackages = null;
    private PackageInfo[] packages;
    private String releaseVersion;
    private byte[] versionInfoAsBytes = null;

    protected VersionInfo() {
        this.packages = null;
    }

    public VersionInfo(boolean ignored) throws VersioningError {
        this.packages = VersionInfo.searchClasspathPackages();
        if (this.packages.length == 0) {
            throw new VersioningError("No WebLogic packages defined in CLASSPATH");
        }
        this.implVendor = this.packages[0].getImplementationVendor();
        this.implTitle = this.packages[0].getImplementationTitle();
        this.implVersion = this.packages[0].getImplementationVersion();
        this.major = this.packages[0].getMajor();
        this.minor = this.packages[0].getMinor();
        this.servicePack = this.packages[0].getServicePack();
        this.rollingPatch = this.packages[0].getRollingPatch();
        this.patchUpdate = this.packages[0].getPatchUpdate();
        this.releaseVersion = this.major + "." + this.minor + "." + this.servicePack + "." + this.rollingPatch + "." + this.patchUpdate;
    }

    public VersionInfo(int major, int minor, int servicePack, int rollingPatch, int patchUpdate) throws VersioningError {
        super(major, minor, servicePack, rollingPatch, patchUpdate, false);
        this.implVendor = defaultImplVendor;
        this.implTitle = defaultImplTitle;
        this.implVersion = defaultImplVersion;
        this.major = major;
        this.minor = minor;
        this.servicePack = servicePack;
        this.rollingPatch = rollingPatch;
        this.patchUpdate = patchUpdate;
        this.packages = this.initializePackages(defaultImplVersion);
        this.releaseVersion = defaultVersionString;
    }

    public VersionInfo(int major, int minor, int servicePack, int rollingPatch, int patchUpdate, boolean temporaryPatch) {
        this(major, minor, servicePack, rollingPatch, patchUpdate, temporaryPatch, null);
    }

    public VersionInfo(int major, int minor, int servicePack, int rollingPatch, int patchUpdate, boolean temporaryPatch, PackageInfo[] packages) {
        super(major, minor, servicePack, rollingPatch, patchUpdate, temporaryPatch);
        this.packages = packages;
    }

    public static synchronized VersionInfo theOne() {
        return SINGLETON.defaultVersionInfo;
    }

    public VersionInfo(String aVersion) {
        super(defaultImplVendor, defaultImplTitle, aVersion);
        this.packages = this.initializePackages(aVersion);
    }

    public static synchronized void initialize(boolean isServer, String _defaultImplVendor, String _defaultImplTitle, String _defaultImplVersion, String _defaultVersionString, int _defaultMajor, int _defaultMinor, int _defaultSP, int _defaultPatch, int _defaultPatchUpdate) {
        searchClasspath = isServer;
        defaultImplVendor = _defaultImplVendor;
        defaultImplTitle = _defaultImplTitle;
        defaultImplVersion = _defaultImplVersion;
        defaultVersionString = _defaultVersionString;
        defaultMajor = _defaultMajor;
        defaultMinor = _defaultMinor;
        defaultSP = _defaultSP;
        defaultPatch = _defaultPatch;
        defaultPatchUpdate = _defaultPatchUpdate;
    }

    public static synchronized void initialize(String _defaultImplVendor, String _defaultImplTitle, String _defaultImplVersion, String _defaultVersionString, int _defaultMajor, int _defaultMinor, int _defaultSP, int _defaultPatch, int _defaultPatchUpdate) {
        VersionInfo.initialize(false, _defaultImplVendor, _defaultImplTitle, _defaultImplVersion, _defaultVersionString, _defaultMajor, _defaultMinor, _defaultSP, _defaultPatch, _defaultPatchUpdate);
    }

    private PackageInfo[] initializePackages(String version) {
        return new PackageInfo[]{new PackageInfo(defaultImplVendor, defaultImplTitle, version)};
    }

    public final boolean compatible(String otherVersionString) {
        VersionInfo otherVersion = new VersionInfo(otherVersionString);
        return VersionInfo.compatibleWith(otherVersion);
    }

    public static final boolean compatibleWith(VersionInfo otherVersion) {
        return otherVersion.getMajor() >= 7;
    }

    public static final String rejectionReasonFor(VersionInfo otherVersion) {
        if (otherVersion.getMajor() < 7) {
            return "Incompatible versions - client: '" + otherVersion.implVersion + "'. client version should be greater than or equal to 7.0 to support interop";
        }
        return null;
    }

    public static final boolean useFiveDigitsFormatFor(VersionInfo peerVersion) {
        return peerVersion.getMajor() > 12 || peerVersion.getMajor() == 12 && (peerVersion.getMinor() > 1 || peerVersion.getMinor() == 1 && peerVersion.getServicePack() > 1);
    }

    public static final boolean is10OrOlder(VersionInfo peerVersion) {
        return peerVersion.getMajor() < 10 || peerVersion.getMajor() == 10 && peerVersion.getMinor() == 0 && peerVersion.getServicePack() == 0 && peerVersion.getRollingPatch() == 0;
    }

    public final PackageInfo[] getPackages() {
        if (searchClasspath && (this.packages == null || this.packages.length <= 1)) {
            if (classpathPackages == null) {
                VersionInfo.searchClasspathPackages();
            }
            if (classpathPackages != null) {
                this.packages = classpathPackages;
            }
        }
        return this.packages;
    }

    public final PackageInfo[] getPackages(boolean wlsMainOnly) {
        if (!searchClasspath) {
            return this.packages;
        }
        if (classpathPackages == null) {
            classpathPackages = VersionInfo.getPackageInfos(SUPPORTED_PREFIXES, wlsMainOnly);
        }
        this.packages = classpathPackages;
        return classpathPackages;
    }

    public final String getReleaseVersion() {
        return this.releaseVersion;
    }

    public static final PackageInfo[] getPackageInfos(String[] prefixes) {
        return VersionInfo.getPackageInfos(prefixes, false);
    }

    public static final PackageInfo[] getPackageInfos(String[] prefixes, boolean wlsMainOnly) {
        boolean matchAll;
        ArrayList<PackageInfo> packages = new ArrayList<PackageInfo>();
        PackageInfo protocolPackageInfo = null;
        boolean bl = matchAll = prefixes != null && (prefixes.length == 0 || prefixes.length == 1 && prefixes[0].equals("*"));
        if (prefixes == null) {
            prefixes = SUPPORTED_PREFIXES;
        }
        Iterator<Manifest> i = ManifestManager.getManifests(wlsMainOnly);
        while (i.hasNext()) {
            Manifest mf = i.next();
            Attributes mainAttributes = mf.getMainAttributes();
            String vendor = (String)mainAttributes.get(Attributes.Name.IMPLEMENTATION_VENDOR);
            if (vendor == null || !vendor.startsWith(BEA_VENDOR_STRING) && !vendor.startsWith(ORACLE_VENDOR_STRING)) continue;
            String implTitle = (String)mainAttributes.get(Attributes.Name.IMPLEMENTATION_TITLE);
            if (implTitle == null) {
                implTitle = "";
            }
            String[] tokens = implTitle.split("\\s");
            String implPrefix = "";
            if (tokens[0] != null) {
                implPrefix = tokens[0];
            }
            implPrefix = implPrefix.trim();
            if (protocolPackageInfo == null && implTitle.startsWith(DEFAULT_PROTOCOL_PRODUCT_ID)) {
                protocolPackageInfo = new PackageInfo((String)mainAttributes.get(Attributes.Name.IMPLEMENTATION_VENDOR), (String)mainAttributes.get(Attributes.Name.IMPLEMENTATION_TITLE), (String)mainAttributes.get(Attributes.Name.IMPLEMENTATION_VERSION));
                continue;
            }
            if (matchAll) {
                packages.add(new PackageInfo((String)mainAttributes.get(Attributes.Name.IMPLEMENTATION_VENDOR), (String)mainAttributes.get(Attributes.Name.IMPLEMENTATION_TITLE), (String)mainAttributes.get(Attributes.Name.IMPLEMENTATION_VERSION)));
                continue;
            }
            for (int x = 0; x < prefixes.length; ++x) {
                if (!implPrefix.equals(prefixes[x])) continue;
                packages.add(new PackageInfo((String)mainAttributes.get(Attributes.Name.IMPLEMENTATION_VENDOR), (String)mainAttributes.get(Attributes.Name.IMPLEMENTATION_TITLE), (String)mainAttributes.get(Attributes.Name.IMPLEMENTATION_VERSION)));
            }
        }
        Object[] o = packages.toArray();
        int packageCount = o.length;
        int retPosition = 0;
        if (protocolPackageInfo != null) {
            ++packageCount;
            retPosition = 1;
        }
        PackageInfo[] ret = new PackageInfo[packageCount];
        if (protocolPackageInfo != null) {
            ret[0] = protocolPackageInfo;
        }
        for (int i2 = 0; i2 < o.length; ++i2) {
            ret[retPosition++] = (PackageInfo)o[i2];
        }
        return ret;
    }

    public final byte[] getVersionInfoForNetworkClassLoader() {
        if (this.versionInfoAsBytes == null) {
            String implVendor = Attributes.Name.IMPLEMENTATION_VENDOR + ": " + this.packages[0].getImplementationVendor();
            String implTitle = Attributes.Name.IMPLEMENTATION_TITLE + ": " + this.packages[0].getImplementationTitle();
            String implVersion = Attributes.Name.IMPLEMENTATION_VERSION + ": " + this.packages[0].getImplementationVersion();
            this.versionInfoAsBytes = (implVendor + "\n" + implTitle + "\n" + implVersion + "\n").getBytes();
        }
        return this.versionInfoAsBytes;
    }

    private static PackageInfo[] searchClasspathPackages() {
        if (classpathPackages == null) {
            classpathPackages = VersionInfo.getPackageInfos(SUPPORTED_PREFIXES);
        }
        return classpathPackages;
    }

    static /* synthetic */ int access$000() {
        return defaultMajor;
    }

    static /* synthetic */ int access$100() {
        return defaultMinor;
    }

    static /* synthetic */ int access$200() {
        return defaultSP;
    }

    static /* synthetic */ int access$300() {
        return defaultPatch;
    }

    static /* synthetic */ int access$400() {
        return defaultPatchUpdate;
    }

    private static class SINGLETON {
        static VersionInfo defaultVersionInfo = new VersionInfo(VersionInfo.access$000(), VersionInfo.access$100(), VersionInfo.access$200(), VersionInfo.access$300(), VersionInfo.access$400());

        private SINGLETON() {
        }
    }
}

