/*
 * Decompiled with CFR 0.152.
 */
package weblogic.common.internal;

import java.io.Serializable;
import weblogic.common.internal.PackageInfo;
import weblogic.common.internal.VersionInfo;
import weblogic.utils.StringUtils;

public final class PeerInfo
extends VersionInfo
implements Serializable,
Comparable {
    static final long serialVersionUID = 6364840763020871921L;
    private int major;
    private int minor;
    private int servicePack;
    private int rollingPatch;
    private int patchUpdate;
    private boolean temporaryPatch;
    private transient boolean isServer;
    private PackageInfo[] packages;
    public static final int WEBLOGIC_MAJOR_VERSION_12 = 12;
    public static final int WEBLOGIC_MINOR_VERSION_1 = 1;
    public static final int WEBLOGIC_SERVICE_PACK_VERSION_1 = 1;
    private static final int WEBLOGIC_SERVICE_PACK_VERSION_3 = 3;
    private static final int WEBLOGIC_MINOR_VERSION_2 = 2;
    public static final PeerInfo VERSION_60 = new PeerInfo(6, 0, 0);
    public static final PeerInfo VERSION_61 = new PeerInfo(6, 1, 0);
    public static final PeerInfo VERSION_612 = new PeerInfo(6, 1, 2);
    public static final PeerInfo VERSION_613 = new PeerInfo(6, 1, 3);
    public static final PeerInfo VERSION_614 = new PeerInfo(6, 1, 4);
    public static final PeerInfo VERSION_70 = new PeerInfo(7, 0, 0);
    public static final PeerInfo VERSION_701 = new PeerInfo(7, 0, 1);
    public static final PeerInfo VERSION_81 = new PeerInfo(8, 1, 0);
    public static final PeerInfo VERSION_811 = new PeerInfo(8, 1, 1);
    public static final PeerInfo VERSION_DIABLO = new PeerInfo(9, 0, 0);
    public static final PeerInfo VERSION_901 = new PeerInfo(9, 0, 1);
    public static final PeerInfo VERSION_910 = new PeerInfo(9, 1, 0);
    public static final PeerInfo VERSION_920 = new PeerInfo(9, 2, 0);
    public static final PeerInfo VERSION_1000 = new PeerInfo(10, 0, 0);
    public static final PeerInfo VERSION_1030 = new PeerInfo(10, 3, 0);
    public static final PeerInfo VERSION_1033 = new PeerInfo(10, 3, 3);
    public static final PeerInfo VERSION_1034 = new PeerInfo(10, 3, 4);
    public static final PeerInfo VERSION_1211 = new PeerInfo(12, 1, 1, 0, 0);
    public static final PeerInfo VERSION_1212 = new PeerInfo(12, 1, 2, 0, 0);
    public static final PeerInfo VERSION_1221 = new PeerInfo(12, 2, 1, 0, 0);
    public static final PeerInfo VERSION_122200 = new PeerInfo(12, 2, 2, 0, 0);
    public static final PeerInfo VERSION_122210 = new PeerInfo(12, 2, 2, 1, 0);
    public static final PeerInfo VERSION_122110 = new PeerInfo(12, 2, 1, 1, 0);
    public static final PeerInfo VERSION_122120 = new PeerInfo(12, 2, 1, 2, 0);
    public static final PeerInfo VERSION_122130 = new PeerInfo(12, 2, 1, 3, 0);
    public static final PeerInfo VERSION_122140 = new PeerInfo(12, 2, 1, 4, 0);
    public static final PeerInfo VERSION_123100 = new PeerInfo(12, 3, 1, 0, 0);
    public static final PeerInfo VERSION_1411 = new PeerInfo(14, 1, 1, 0, 0);
    public static final PeerInfo FOREIGN = new PeerInfo(0, 0, 0);
    public static final String SIGNED_HEARTBEAT_VERSION = "0,0,0,0,0";
    public static final String UNSIGNED_HEARTBEAT_VERSION = "0,0,0";

    public PeerInfo() {
    }

    public PeerInfo(int major, int minor, int servicePack) {
        this(major, minor, servicePack, 0, 0);
    }

    public PeerInfo(int major, int minor, int servicePack, int rollingPatch, int patchUpdate) {
        this(major, minor, servicePack, rollingPatch, patchUpdate, false, null);
    }

    public PeerInfo(int major, int minor, int servicePack, int rollingPatch, int patchUpdate, boolean temporaryPatch, PackageInfo[] packages) {
        super(major, minor, servicePack, rollingPatch, patchUpdate, temporaryPatch, packages);
        this.major = major;
        this.minor = minor;
        this.servicePack = servicePack;
        this.rollingPatch = rollingPatch;
        this.patchUpdate = patchUpdate;
        this.temporaryPatch = temporaryPatch;
        this.packages = packages;
    }

    public static PeerInfo getPeerInfo() {
        return SINGLETON.instance;
    }

    public static PeerInfo getPeerInfoForWire() {
        return SINGLETON_FOR_WIRE.instance;
    }

    public static PeerInfo getPeerInfo(String version) {
        String[] versionParts = StringUtils.splitCompletely(version, ",.");
        if (versionParts.length < 3) {
            return null;
        }
        switch (versionParts.length) {
            case 3: {
                return new PeerInfo(Integer.parseInt(versionParts[0]), Integer.parseInt(versionParts[1]), Integer.parseInt(versionParts[2]));
            }
            case 4: {
                return new PeerInfo(Integer.parseInt(versionParts[0]), Integer.parseInt(versionParts[1]), Integer.parseInt(versionParts[2]), Integer.parseInt(versionParts[3]), 0);
            }
            case 5: {
                return new PeerInfo(Integer.parseInt(versionParts[0]), Integer.parseInt(versionParts[1]), Integer.parseInt(versionParts[2]), Integer.parseInt(versionParts[3]), Integer.parseInt(versionParts[4]));
            }
        }
        return null;
    }

    public PeerInfo(int major, int minor, int servicePack, int rollingPatch) {
        super(major, minor, servicePack, rollingPatch, 0, false);
        this.major = major;
        this.minor = minor;
        this.servicePack = servicePack;
        this.rollingPatch = rollingPatch;
    }

    public int compareTo(Object o) {
        PeerInfo peerInfo = (PeerInfo)o;
        int i = this.major - peerInfo.major;
        if (i != 0) {
            return i;
        }
        i = this.minor - peerInfo.minor;
        if (i != 0) {
            return i;
        }
        i = this.servicePack - peerInfo.servicePack;
        if (i != 0) {
            return i;
        }
        i = this.rollingPatch - peerInfo.rollingPatch;
        if (i != 0) {
            return i;
        }
        i = this.patchUpdate - peerInfo.patchUpdate;
        if (i != 0) {
            return i;
        }
        if (!(this.temporaryPatch ^ peerInfo.temporaryPatch)) {
            return 0;
        }
        return this.temporaryPatch ? 1 : -1;
    }

    public boolean equals(Object o) {
        if (!(o instanceof PeerInfo)) {
            return false;
        }
        return o != null && this.compareTo(o) == 0;
    }

    public int hashCode() {
        return this.major ^ this.minor ^ this.servicePack ^ this.rollingPatch ^ this.patchUpdate;
    }

    @Override
    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append("PeerInfo(");
        ret.append(this.major).append(".");
        ret.append(this.minor).append(".");
        ret.append(this.servicePack).append(".");
        ret.append(this.rollingPatch);
        if (!this.isPre1212Peer()) {
            ret.append(".").append(this.patchUpdate);
        }
        if (this.temporaryPatch) {
            ret.append("t");
        }
        ret.append(", [");
        if (this.packages != null) {
            for (int i = 0; i < this.packages.length; ++i) {
                ret.append(this.packages[i].toString());
                if (i == this.packages.length - 1) continue;
                ret.append(", ");
            }
        } else {
            ret.append("none");
        }
        ret.append("])");
        return ret.toString();
    }

    public void setIsServer(boolean isServer) {
        this.isServer = isServer;
    }

    public boolean isServer() {
        return this.isServer;
    }

    private boolean isPre1212Peer() {
        return this.major < 12 || this.major == 12 && (this.minor < 1 || this.minor == 1 && this.servicePack <= 1);
    }

    public String getVersionAsString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.major).append(".");
        sb.append(this.minor).append(".");
        sb.append(this.servicePack).append(".");
        sb.append(this.rollingPatch);
        if (!this.isPre1212Peer()) {
            sb.append(".").append(this.patchUpdate);
        }
        return sb.toString();
    }

    public boolean is1213Peer() {
        return this.major > 12 || this.major == 12 && (this.minor > 1 || this.minor == 1 && this.servicePack >= 3);
    }

    public boolean is1221Peer() {
        return this.major > 12 || this.major == 12 && (this.minor > 2 || this.minor == 2 && this.servicePack >= 1);
    }

    public static boolean isPeerVersionInVersionGap(PeerInfo pi, PeerInfo info1, PeerInfo info2) {
        return pi.compareTo(info1) >= 0 && pi.compareTo(info2) < 0;
    }

    private static class SINGLETON_FOR_WIRE {
        static PeerInfo instance;

        private SINGLETON_FOR_WIRE() {
        }

        static {
            VersionInfo vi = VersionInfo.theOne();
            instance = new PeerInfo(vi.getMajor(), vi.getMinor(), vi.getServicePack(), vi.getRollingPatch(), vi.getPatchUpdate(), vi.hasTemporaryPatch(), null);
        }
    }

    private static class SINGLETON {
        static PeerInfo instance;

        private SINGLETON() {
        }

        static {
            VersionInfo vi = VersionInfo.theOne();
            instance = new PeerInfo(vi.getMajor(), vi.getMinor(), vi.getServicePack(), vi.getRollingPatch(), vi.getPatchUpdate(), vi.hasTemporaryPatch(), vi.getPackages());
        }
    }
}

