/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.core.registryhelper.utils;

import com.oracle.core.registryhelper.RegistryListener;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MonitorableMap<K, V>
implements Map<K, V>,
Serializable {
    private static final long serialVersionUID = -7912892707014214989L;
    private final Map<K, V> backingMap;
    private final HashSet<RegistryListener<Map.Entry<K, V>>> listeners = new HashSet();

    public MonitorableMap() {
        this(new HashMap());
    }

    public MonitorableMap(Map<K, V> paramBackingMap) {
        if (paramBackingMap == null) {
            throw new NullPointerException();
        }
        this.backingMap = paramBackingMap;
    }

    public synchronized void addListener(RegistryListener<Map.Entry<K, V>> listener) {
        if (listener == null) {
            return;
        }
        Set<Map.Entry<K, V>> sets = this.backingMap.entrySet();
        listener.init(sets);
        this.listeners.add(listener);
    }

    public synchronized void removeListener(RegistryListener<Map.Entry<K, V>> listener) {
        this.listeners.remove(listener);
    }

    private void notifyRemove(Map.Entry<K, V> removed) {
        for (RegistryListener<Map.Entry<K, V>> listener : this.listeners) {
            listener.removed(removed);
        }
    }

    private void notifyAdd(Map.Entry<K, V> added) {
        for (RegistryListener<Map.Entry<K, V>> listener : this.listeners) {
            listener.added(added);
        }
    }

    private void notifyModify(Map.Entry<K, V> oldValue, Map.Entry<K, V> newValue) {
        for (RegistryListener<Map.Entry<K, V>> listener : this.listeners) {
            listener.modified(oldValue, newValue);
        }
    }

    @Override
    public synchronized void clear() {
        for (Map.Entry<K, V> entry : this.backingMap.entrySet()) {
            this.notifyRemove(entry);
        }
        this.backingMap.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.backingMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.backingMap.containsValue(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.backingMap.entrySet();
    }

    @Override
    public V get(Object key) {
        return this.backingMap.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.backingMap.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        return this.backingMap.keySet();
    }

    @Override
    public V put(K key, V value) {
        boolean isModify = false;
        Map.Entry oldValue = null;
        final K fKey = key;
        if (this.backingMap.containsKey(key)) {
            isModify = true;
            final V fOldValue = this.backingMap.get(key);
            oldValue = new Map.Entry<K, V>(){

                @Override
                public K getKey() {
                    return fKey;
                }

                @Override
                public V getValue() {
                    return fOldValue;
                }

                @Override
                public V setValue(V paramValue) {
                    throw new IllegalStateException();
                }
            };
        }
        final V fNewValue = value;
        Map.Entry newValue = new Map.Entry<K, V>(){

            @Override
            public K getKey() {
                return fKey;
            }

            @Override
            public V getValue() {
                return fNewValue;
            }

            @Override
            public V setValue(V value) {
                throw new IllegalStateException();
            }
        };
        if (isModify) {
            this.notifyModify(oldValue, newValue);
        } else {
            this.notifyAdd(newValue);
        }
        return this.backingMap.put(key, value);
    }

    @Override
    public synchronized void putAll(Map<? extends K, ? extends V> t) {
        if (t == null) {
            return;
        }
        for (Map.Entry<K, V> entry : t.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public synchronized V remove(Object key) {
        boolean contains = this.backingMap.containsKey(key);
        if (contains) {
            final Object fKey = key;
            final V fValue = this.backingMap.get(key);
            this.notifyRemove(new Map.Entry<Object, V>(){

                @Override
                public Object getKey() {
                    return fKey;
                }

                @Override
                public V getValue() {
                    return fValue;
                }

                @Override
                public V setValue(V value) {
                    throw new IllegalStateException();
                }
            });
        }
        return this.backingMap.remove(key);
    }

    @Override
    public int size() {
        return this.backingMap.size();
    }

    @Override
    public Collection<V> values() {
        return this.backingMap.values();
    }

    public String toString() {
        return "MonitorableMap(" + this.backingMap + "," + System.identityHashCode(this) + ")";
    }
}

