/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.classloader;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashSet;

public class SymLinkDetectorFilenameFilter
implements FilenameFilter {
    HashSet<Path> visitedPaths = new HashSet();
    Reporter reporter;

    public SymLinkDetectorFilenameFilter(Reporter reporter) {
        this.reporter = reporter;
    }

    @Override
    public boolean accept(File dir, String name) {
        if (name == null || name.isEmpty()) {
            try {
                Path p = dir.toPath();
                if (Files.isSymbolicLink(p)) {
                    Path sympath = Files.readSymbolicLink(p);
                    p = p.getParent().resolve(sympath).normalize();
                }
                if (this.visitedPaths.contains(p)) {
                    if (this.reporter != null) {
                        this.reporter.symlinkCycleDetected(dir.getPath(), p.toFile().getCanonicalPath());
                    }
                    throw new RuntimeException("Detected a cyclical symlink: " + dir.getPath() + " maps to " + p.toFile().getCanonicalPath());
                }
                this.visitedPaths.add(p);
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        return true;
    }

    public static interface Reporter {
        public void symlinkCycleDetected(String var1, String var2);
    }
}

