/*
 * Decompiled with CFR 0.152.
 */
package com.bea.logging;

import java.util.logging.Level;

public class LogLevel
extends Level {
    public static final int OFF_INT = Integer.MAX_VALUE;
    public static final int EMERGENCY_INT = 1090;
    public static final int ALERT_INT = 1060;
    public static final int CRITICAL_INT = 1030;
    public static final int ERROR_INT = 980;
    public static final int WARNING_INT = Level.WARNING.intValue();
    public static final int NOTICE_INT = 880;
    public static final int INFO_INT = Level.INFO.intValue();
    public static final int DEBUG_INT = 495;
    public static final int TRACE_INT = 295;
    public static final LogLevel OFF = new LogLevel("Off", Integer.MAX_VALUE, 0);
    public static final LogLevel EMERGENCY = new LogLevel("Emergency", 1090, 1);
    public static final LogLevel CRITICAL = new LogLevel("Critical", 1030, 4);
    public static final LogLevel ERROR = new LogLevel("Error", 980, 8);
    public static final LogLevel ALERT = new LogLevel("Alert", 1060, 2);
    public static final LogLevel NOTICE = new LogLevel("Notice", 880, 32);
    public static final LogLevel DEBUG = new LogLevel("Debug", 495, 128);
    public static final LogLevel WARNING = new LogLevel("Warning", WARNING_INT, 16);
    public static final LogLevel INFO = new LogLevel("Info", INFO_INT, 64);
    public static final LogLevel TRACE = new LogLevel("Trace", 295, 256);
    public static final String LOGGING_TEXT_PROPS = "weblogic.i18n.logging.LoggingTextLocalizer";
    private static final long serialVersionUID = 1796084591280954044L;
    private final int severity;
    private String localizedName;

    protected LogLevel(String name, int value, int severity) {
        super(name, value, LOGGING_TEXT_PROPS);
        this.severity = severity;
        this.localizedName = super.getLocalizedName();
    }

    @Deprecated
    protected String getHeader(Level level) {
        return level.getLocalizedName();
    }

    public int getSeverity() {
        return this.severity;
    }

    @Override
    public String getLocalizedName() {
        return this.localizedName;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null && obj instanceof LogLevel) {
            LogLevel other = (LogLevel)obj;
            return this.intValue() == other.intValue() && this.getName().equals(other.getName());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.intValue();
    }

    public static Level getLevel(int severity) {
        switch (severity) {
            case 0: {
                return OFF;
            }
            case 1: {
                return EMERGENCY;
            }
            case 2: {
                return ALERT;
            }
            case 4: {
                return CRITICAL;
            }
            case 32: {
                return NOTICE;
            }
            case 8: {
                return ERROR;
            }
            case 16: {
                return WARNING;
            }
            case 64: {
                return INFO;
            }
            case 128: {
                return DEBUG;
            }
            case 256: {
                return TRACE;
            }
        }
        return INFO;
    }

    public static int getSeverity(Level level) {
        int levelValue = level.intValue();
        if (levelValue == Integer.MAX_VALUE) {
            return 0;
        }
        if (levelValue >= 1090) {
            return 1;
        }
        if (levelValue >= 1060) {
            return 2;
        }
        if (levelValue >= 1030) {
            return 4;
        }
        if (levelValue >= 980) {
            return 8;
        }
        if (levelValue >= WARNING_INT) {
            return 16;
        }
        if (levelValue >= 880) {
            return 32;
        }
        if (levelValue >= INFO_INT) {
            return 64;
        }
        if (levelValue >= 495) {
            return 128;
        }
        return 256;
    }
}

