/*
 * Decompiled with CFR 0.152.
 */
package com.bea.core.security.managers.internal;

import java.util.LinkedList;
import weblogic.security.subject.AbstractSubject;

public class WLSStackService {
    private static ThreadLocal<LinkedList<AbstractSubject>> stack = new ThreadLocal<LinkedList<AbstractSubject>>(){

        @Override
        protected synchronized LinkedList<AbstractSubject> initialValue() {
            return new LinkedList<AbstractSubject>();
        }
    };

    public AbstractSubject peekIdentity() {
        LinkedList<AbstractSubject> subjectStack = stack.get();
        if (subjectStack.size() <= 0) {
            return null;
        }
        return subjectStack.getLast();
    }

    public AbstractSubject popIdentity() {
        LinkedList<AbstractSubject> subjectStack = stack.get();
        if (subjectStack.size() <= 0) {
            return null;
        }
        return subjectStack.removeLast();
    }

    public void pushIdentity(AbstractSubject identity) {
        if (identity == null) {
            throw new IllegalArgumentException();
        }
        LinkedList<AbstractSubject> subjectStack = stack.get();
        subjectStack.addLast(identity);
    }

    public int getSize() {
        return stack.get().size();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        LinkedList<AbstractSubject> ids = stack.get();
        int lcv = 0;
        for (AbstractSubject id : ids) {
            sb.append("\t" + lcv++ + ". " + id + "\n");
        }
        return "SecurityStackService(" + System.identityHashCode(this) + ",\n" + sb.toString() + ")";
    }
}

