/*
 * Decompiled with CFR 0.152.
 */
package weblogic.utils.io.oif;

import java.io.ObjectInputFilter;
import weblogic.utils.io.oif.WebLogicObjectInputFilter;
import weblogic.utils.io.oif.WebLogicObjectInputFilterWrapperHelper;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class WebLogicObjectInputFilterWrapper
implements ObjectInputFilter {
    private ObjectInputFilter delegateAllowFilter;
    private ObjectInputFilter delegateBlockFilter;
    private WebLogicObjectInputFilter.Scope scope;

    public WebLogicObjectInputFilterWrapper(ObjectInputFilter delegateFilter, WebLogicObjectInputFilter.Scope scope) {
        this.delegateAllowFilter = delegateFilter;
        this.delegateBlockFilter = delegateFilter;
        this.scope = scope;
    }

    public WebLogicObjectInputFilterWrapper(ObjectInputFilter delegateAllowFilter, ObjectInputFilter delegateBlockFilter, WebLogicObjectInputFilter.Scope scope) {
        this.delegateAllowFilter = delegateAllowFilter;
        this.delegateBlockFilter = delegateBlockFilter;
        this.scope = scope;
    }

    public ObjectInputFilter getAllowFilter() {
        return this.delegateAllowFilter;
    }

    public ObjectInputFilter getBlockFilter() {
        return this.delegateBlockFilter;
    }

    public void setFilter(ObjectInputFilter delegateFilter) {
        this.delegateAllowFilter = delegateFilter;
        this.delegateBlockFilter = delegateFilter;
    }

    public void setFilter(ObjectInputFilter delegateAllowFilter, ObjectInputFilter delegateBlockFilter) {
        this.delegateAllowFilter = delegateAllowFilter;
        this.delegateBlockFilter = delegateBlockFilter;
    }

    @Override
    public ObjectInputFilter.Status checkInput(ObjectInputFilter.FilterInfo filterInfo) {
        Class<?> clazz = null;
        String normalizedName = null;
        if (filterInfo.serialClass() != null) {
            clazz = filterInfo.serialClass();
        }
        if (clazz != null) {
            normalizedName = WebLogicObjectInputFilter.normalizeClassName(clazz.getName());
        }
        if (normalizedName != null && WebLogicObjectInputFilter.isAllowListRecordingEnabled()) {
            WebLogicObjectInputFilterWrapperHelper.recordInputClass(normalizedName, this.scope);
        }
        if (normalizedName != null && WebLogicObjectInputFilter.isAllowListEnabled()) {
            ObjectInputFilter.Status status = ObjectInputFilter.Status.UNDECIDED;
            if (this.delegateAllowFilter != null) {
                status = this.delegateAllowFilter.checkInput(filterInfo);
            }
            if (status == ObjectInputFilter.Status.REJECTED) {
                WebLogicObjectInputFilter.setDeniedMessage(normalizedName + " : Status " + status);
                if (WebLogicObjectInputFilter.isAllowListLogViolationAction() && this.delegateBlockFilter != null) {
                    ObjectInputFilter.Status blockStatus = this.delegateBlockFilter.checkInput(filterInfo);
                    return blockStatus;
                }
            }
            return status;
        }
        ObjectInputFilter.Status status = ObjectInputFilter.Status.UNDECIDED;
        if (this.delegateBlockFilter != null) {
            status = this.delegateBlockFilter.checkInput(filterInfo);
        }
        return status;
    }
}

